/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.commons;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class Objs {
    public static <OUT, IN> OUT decode(IN obj, IN compare, OUT then, OUT orElse) {
        return Objs.equals(obj, compare) ? then : orElse;
    }

    public static boolean isNull(Object obj) {
        return null == obj;
    }

    public static boolean isNotNull(Object obj) {
        return obj != null;
    }

    public static boolean equals(Object a, Object b) {
        return a == b || Objs.isNotNull(a) && a.equals(b);
    }

    public static <T> T notNull(T obj) {
        if (Objs.isNull(obj)) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T notNull(T obj, String message) {
        if (Objs.isNull(obj)) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static <X extends Throwable, T> T notNull(T obj, Supplier<? extends X> exceptionSupplier) throws X {
        if (Objs.isNull(obj)) {
            throw (Throwable)Objs.notNull(exceptionSupplier).get();
        }
        return obj;
    }

    public static <T> void notNullDo(T obj, Consumer<T> action) {
        if (Objs.isNotNull(obj)) {
            Objs.notNull(action).accept(obj);
        }
    }

    public static <T> T notNullElse(T obj, T defaultObj) {
        return Objs.isNotNull(obj) ? obj : Objs.notNull(defaultObj);
    }

    public static <T> T notNullElseLazy(T obj, Supplier<? extends T> supplier) {
        return Objs.isNotNull(obj) ? obj : Objs.notNull(Objs.notNull(supplier).get());
    }

    public static <T, R> R notNullReplaceElse(T obj, R replaceObj, R defaultObj) {
        return Objs.isNotNull(obj) ? Objs.notNull(replaceObj) : Objs.notNull(defaultObj);
    }

    public static <T, R> R notNullReplaceElseLazy(T obj, Supplier<? extends R> replaceSupplier, Supplier<? extends R> defaultSupplier) {
        return Objs.isNotNull(obj) ? Objs.notNull(Objs.notNull(replaceSupplier).get()) : Objs.notNull(Objs.notNull(defaultSupplier).get());
    }
}

