/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.commons;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HexFormat;
import tech.deplant.commons.Strings;

public class Hexes {
    private static String cleanHexString(String hexString) {
        boolean isNegative = false;
        if (Strings.isEmpty((String)hexString)) {
            return "00";
        }
        if (((String)hexString).startsWith("0x")) {
            hexString = Strings.notEmptyElse(Strings.substr((String)hexString, 2), "00");
        } else if (((String)hexString).startsWith("-0x")) {
            isNegative = true;
            hexString = Strings.notEmptyElse(Strings.substr((String)hexString, 3), "00");
        } else if (((String)hexString).startsWith("-")) {
            isNegative = true;
            hexString = Strings.notEmptyElse(Strings.substr((String)hexString, 1), "00");
        }
        if (((String)hexString).length() % 2 != 0) {
            hexString = "0" + (String)hexString;
        }
        if (isNegative) {
            hexString = "-" + (String)hexString;
        }
        return Strings.notEmptyElse((String)hexString, "00");
    }

    private static byte[] asBytes(String hexString) {
        return HexFormat.of().parseHex(hexString);
    }

    public static int asInt32(String hexString) {
        return Integer.parseInt(Hexes.cleanHexString(hexString), 16);
    }

    public static int asUint32(String hexString) {
        return Integer.parseUnsignedInt(Hexes.cleanHexString(hexString), 16);
    }

    public static String fromInt32(int int32) {
        return Integer.toString(int32, 16);
    }

    public static String fromUint32(int uint32) {
        return Integer.toUnsignedString(uint32, 16);
    }

    public static long asInt64(String hexString) {
        return Long.parseLong(Hexes.cleanHexString(hexString), 16);
    }

    public static long asUint64(String hexString) {
        return Long.parseUnsignedLong(Hexes.cleanHexString(hexString), 16);
    }

    public static String fromInt64(long int64) {
        return Long.toUnsignedString(int64, 16);
    }

    public static String fromUint64(long uint64) {
        return Long.toString(uint64, 16);
    }

    public static BigInteger asBigInt(String hexString) {
        String s = Hexes.cleanHexString(hexString);
        if (s.startsWith("-")) {
            return new BigInteger(s, 16);
        }
        return new BigInteger(1, HexFormat.of().parseHex(s));
    }

    public static BigDecimal asBigDec(String hexString, int scale) {
        return new BigDecimal(Hexes.asBigInt(hexString), scale);
    }
}

