/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.commons;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import tech.deplant.commons.Hexes;

public class Dates {
    public static Instant fromUnixLong(long unixTimeLong) {
        return Instant.ofEpochSecond(unixTimeLong);
    }

    public static Instant fromUnixString(String unixTimeString) {
        return Dates.fromUnixLong(Long.parseLong(unixTimeString));
    }

    public static Instant fromUnixHexString(String hexString) {
        return Dates.fromUnixLong(Hexes.asUint64(hexString));
    }

    public static String toIsoString(Instant utcMoment, int offsetMillis) {
        return Dates.toIsoString(Dates.toClientOffset(utcMoment, offsetMillis));
    }

    public static String toIsoString(Instant utcMoment) {
        return Dates.toIsoString(utcMoment, 0);
    }

    public static String toIsoString(OffsetDateTime dt) {
        return Dates.toFormattedString(dt, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static String toCustomString(Instant utcMoment, int offsetMillis, String formatMask) {
        return Dates.toFormattedString(Dates.toClientOffset(utcMoment, offsetMillis), DateTimeFormatter.ofPattern(formatMask));
    }

    public static String toCustomString(Instant utcMoment, String formatMask) {
        return Dates.toFormattedString(Dates.toClientOffset(utcMoment, 0), DateTimeFormatter.ofPattern(formatMask));
    }

    public static OffsetDateTime toClientOffset(Instant utcMoment, int offsetMillis) {
        return utcMoment.atOffset(ZoneOffset.ofTotalSeconds(offsetMillis / 1000));
    }

    public static String toFormattedString(OffsetDateTime dt, DateTimeFormatter formatter) {
        return dt.toZonedDateTime().format(formatter);
    }
}

