package tech.deepdreams.worker.deductionbasis;

import java.util.Map;
import tech.deepdreams.worker.api.services.DeductionBasisService;
import tech.deepdreams.worker.api.util.CommonCodes;
import tech.deepdreams.employee.enums.MaritalStatus ;
import tech.deepdreams.worker.api.enums.CountryCode;

public class Sharesv2022Impl implements DeductionBasisService{

	
	public Double calculate(Map<String, Object> params, Map<String, Integer> advantagesInKind) {
		MaritalStatus status = (MaritalStatus) params.getOrDefault(CommonCodes.CODE_EMPLOYEE_MARITAL_STATUS, MaritalStatus.CELIBATAIRE) ;
		Integer children = (Integer) params.getOrDefault(CommonCodes.CODE_EMPLOYEE_CHILDREN, 0) ;
		
		if(children == 0) {
			return 1.0 ;
		} else if(MaritalStatus.MARIE.equals(status)) {
			return 2.0 + 0.5 * Math.min(children, 6) ;
		} else if(status.equals(MaritalStatus.CELIBATAIRE) ||  status.equals(MaritalStatus.DIVORCE)) {
			return 2.0 + 0.5 * (Math.min(children, 6) - 1) ;
		}
		
		return 1.0 ;
	}

	
	public CountryCode country() {
		return CountryCode.GAB ;
	}

	
	public String code() {
		return CommonCodes.CODE_EMPLOYEE_SHARES ;
	}

	
	public int version() {
		return 2022 ;
	}

}
