package tech.deepdreams.worker.deductionbasis;
import static tech.deepdreams.worker.constants.ElementCode.*;
import static tech.deepdreams.worker.constants.LocalConstantCode.*;
import java.util.Arrays;
import java.util.Map;
import tech.deepdreams.worker.api.services.DeductionBasisService;
import tech.deepdreams.worker.api.util.CommonCodes;
import tech.deepdreams.worker.constants.ElementCode;
import tech.deepdreams.worker.constants.LocalConstantCode;
import tech.deepdreams.worker.api.context.DeductionBasisContext;
import tech.deepdreams.worker.api.context.DeductionContext;
import tech.deepdreams.worker.api.enums.CountryCode;

public class GrossTaxableSalaryv2022Impl implements DeductionBasisService{
	private static final Double MAX_INTERNSHIP_ALLOWANCE = 500_000.0 ;
	private static final Double MAX_CHILD_ALLOWANCE = 20_000.0 ;
	private static final Double MAX_ACCOMODATION_ALLOWANCE = 250_000.0 ;

	
	public Double calculate(Map<String, Object> params, Map<String, Integer> advantagesInKind) {
		DeductionBasisContext context = new DeductionBasisContext(CountryCode.GAB, LocalConstantCode.CODE_GROSS_SALARY, 2019) ;
		Double grossSalary = context.calculate(params, advantagesInKind) ;
		
		Double article91BisItemsAmount = params.entrySet()
					.stream()
					.filter(entry -> {
						int key = Integer.parseInt(entry.getKey()) ;
					 	boolean all = key >= 200 && key <= 369 ; 
						boolean except = Arrays.asList(ARTICLES_91BIS_ITEMS).contains(entry.getKey()) ; 
						return all && ! except ;
					})
					.mapToDouble(entry -> {
						return Double.parseDouble(entry.getValue().toString()) ;
					})
					.sum() ;
		
		Double cnssAmount = new DeductionContext(CountryCode.GAB, ElementCode.CODE_CNSS, 2016).calculateEmployee(params) ;
		Double cnamgsAmount = new DeductionContext(CountryCode.GAB, ElementCode.CODE_CNAMGS, 2016).calculateEmployee(params) ;
		
		Double advantagesInKindBasis = grossSalary - article91BisItemsAmount - cnssAmount - cnamgsAmount ;
		
		Double advantagesInKindAmount =  advantagesInKind.entrySet()
					.stream()
					.filter(entry -> {
						return Arrays.asList(ADVANTAGES_IN_KIND).contains(entry.getKey()) ;   
					})
					.mapToDouble(entry -> {
					return switch(entry.getKey()) {
									case CODE_ACCOMODATION :
										yield 0.15 * advantagesInKindBasis ;
									case CODE_DOMESTIC, CODE_WATER, CODE_ELECTRICITY :
										yield 0.05 * advantagesInKindBasis ;
									case CODE_FOOD :
										yield 0.25 * advantagesInKindBasis ;
									default:
										yield 0.0 ;
							} ;
					})
					.sum() ;
		
		Double taxableItemsAmount = params.entrySet()
					.stream()
					.filter(entry -> {
						int key = Integer.parseInt(entry.getKey()) ;
					 	boolean all = key >= 200 && key <= 369 ; 
						return all && ! Arrays.asList(ARTICLES_91BIS_ITEMS).contains(entry.getKey()) 
								   && ! Arrays.asList(ARTICLES_91_11_ITEMS).contains(entry.getKey()) ;   
					})
					.mapToDouble(entry -> {
						return switch(entry.getKey()) {
									case CODE_ACCOMODATION_ALLOWANCE :
										Double grossSalaryBefAcc = grossSalary - Double.parseDouble(entry.getValue().toString()) ;
										Double maxAccAmount = Math.min(0.40 * grossSalaryBefAcc,  MAX_ACCOMODATION_ALLOWANCE) ;
										Double additionalAmount = Math.min(maxAccAmount - Double.parseDouble(entry.getValue().toString()),  0.0) ;
										yield Math.min(Double.parseDouble(entry.getValue().toString()), 0.15 * advantagesInKindBasis) + additionalAmount ;
									
									case CODE_DOMESTIC_ALLOWANCE, CODE_WATER_ALLOWANCE, CODE_ELECTRICITY_ALLOWANCE :
										yield Math.min(Double.parseDouble(entry.getValue().toString()), 0.05 * advantagesInKindBasis) ;
									
									case CODE_FOOD_ALLOWANCE :
										yield Math.min(Double.parseDouble(entry.getValue().toString()), Math.min(0.25 * advantagesInKindBasis, 120_000.0)) ;
									
									case CODE_FAMILY_ALLOWANCE :
										Double children = (Double) params.getOrDefault(CommonCodes.CODE_EMPLOYEE_CHILDREN, 0.0) ;
										yield Math.min(Double.parseDouble(entry.getValue().toString()) - children*MAX_CHILD_ALLOWANCE, 0.0) ;
										
									case CODE_INTERNSHIP_ALLOWANCE :
										yield Math.max(Double.parseDouble(entry.getValue().toString()) - MAX_INTERNSHIP_ALLOWANCE, 0.0) ;
									
									case CODE_VOLUNTARY_DEPART_ALLOWANCE, CODE_DISMISSAL_ALLOWANCE :
										yield 0.0 ;
									
									case CODE_RETIREMENT_ALLOWANCE, CODE_GOOD_SEPARATION_ALLOWANCE :
										yield 0.5 * Double.parseDouble(entry.getValue().toString()) ;
									
									default:
										yield Double.parseDouble(entry.getValue().toString()) ;
						} ;
						
					})
					.sum() ;
		
		Double article9111ItemsAmount =  params.entrySet()
					.stream()
					.filter(entry -> {
						return Arrays.asList(ARTICLES_91_11_ITEMS).contains(entry.getKey()) ;   
					})
					.mapToDouble(entry -> {
						return Double.parseDouble(entry.getValue().toString()) ;
					})
					.sum() ;
		
		return taxableItemsAmount + article9111ItemsAmount + advantagesInKindAmount - cnssAmount - cnamgsAmount ;
	}

	
	public CountryCode country() {
		return CountryCode.GAB ;
	}

	
	public String code() {
		return CODE_GROSS_TAXABLE_SALARY ;
	}

	
	public int version() {
		return 2022 ;
	}

	
	private static final String[] ADVANTAGES_IN_KIND = new String[] { CODE_ACCOMODATION, CODE_DOMESTIC, CODE_WATER,
			CODE_ELECTRICITY, CODE_FOOD } ;
	
	private static final String[] INDEMNITIES_IN_KIND = new String[] { CODE_ACCOMODATION_ALLOWANCE, CODE_DOMESTIC_ALLOWANCE, 
			CODE_WATER_ALLOWANCE, CODE_ELECTRICITY_ALLOWANCE, CODE_FOOD_ALLOWANCE } ;
	
	// End of the years primes and allowances
	private static final String[] ARTICLES_91_11_ITEMS = new String[] { CODE_EFFICIENCY_BONUS, CODE_PERFORMANCE_BONUS,
			CODE_PROFIT_SHARING_BONUS, CODE_GRATIFICATION_BONUS, CODE_YEAR_END_BONUS, CODE_RESULT_BONUS, CODE_THIRTEENTH_MONTH_BONUS } ;
	
	// Exempted
	private static final String[] ARTICLES_91BIS_ITEMS = new String[] { CODE_REPRESENTATION_ALLOWANCE, CODE_RESPONSIBILITY_ALLOWANCE, 
			CODE_TRAVEL_ALLOWANCE, CODE_CASH_BONUS, CODE_CLOTHES_ALLOWANCE, CODE_MISSION_ALLOWANCE, CODE_VEHICLE_ALLOWANCE, 
			CODE_VEHICLE_MAINTENANCE_ALLOWANCE, CODE_TRANSPORT_ALLOWANCE } ;
	
	// Services rendered items and dismissal
	private static final String[] ARTICLES_91TER_ITEMS = new String[] { CODE_VOLUNTARY_DEPART_ALLOWANCE, CODE_DISMISSAL_ALLOWANCE,
			CODE_RETIREMENT_ALLOWANCE, CODE_GOOD_SEPARATION_ALLOWANCE, CODE_SERVICES_RENDERED_ALLOWANCE } ;
}
