package tech.deepdreams.worker.deductionbasis;
import static tech.deepdreams.worker.constants.LocalConstantCode.*;
import java.util.Map;
import tech.deepdreams.worker.api.services.DeductionBasisService;
import tech.deepdreams.worker.api.enums.CountryCode;

public class GrossSalaryv2019Impl implements DeductionBasisService{

	
	public Double calculate(Map<String, Object> params, Map<String, Integer> advantagesInKind) {
		return params.entrySet()
					 .stream()
					 .filter(entry -> {
						int key = Integer.parseInt(entry.getKey()) ;
					 	return key >= 200 && key <= 369 ;   
					 })
					 .mapToDouble(entry -> {
					 	return Double.parseDouble(entry.getValue().toString()) ;
					 })
					 .sum() ;
	}			

	
	public CountryCode country() {
		return CountryCode.GAB ;
	}

	
	public String code() {
		return CODE_GROSS_SALARY  ;
	}

	
	public int version() {
		return 2019 ;
	}

}
