package tech.deepdreams.worker.deductionbasis;
import static tech.deepdreams.worker.constants.ElementCode.*;
import static tech.deepdreams.worker.constants.LocalConstantCode.*;
import java.util.Arrays;
import java.util.Map;
import tech.deepdreams.worker.api.services.DeductionBasisService;
import tech.deepdreams.worker.constants.ElementCode;
import tech.deepdreams.worker.constants.LocalConstantCode;
import tech.deepdreams.worker.api.context.DeductionBasisContext;
import tech.deepdreams.worker.api.context.DeductionContext;
import tech.deepdreams.worker.api.enums.CountryCode;

public class ContribSalaryv2016Impl implements DeductionBasisService{

	
	public Double calculate(Map<String, Object> params, Map<String, Integer> advantagesInKind) {
		DeductionBasisContext context = new DeductionBasisContext(CountryCode.GAB, LocalConstantCode.CODE_GROSS_SALARY, 2019) ;
		Double grossSalary = context.calculate(params, advantagesInKind) ;
		
		Double article91BisItemsAmount = params.entrySet()
					.stream()
					.filter(entry -> {
						int key = Integer.parseInt(entry.getKey()) ;
					 	boolean all = key >= 200 && key <= 369 ; 
						boolean except = Arrays.asList(ARTICLES_91BIS_ITEMS).contains(entry.getKey()) ; 
						return all && ! except ;
					})
					.mapToDouble(entry -> {
						return Double.parseDouble(entry.getValue().toString()) ;
					})
					.sum() ;
		
		Double cnssAmount = new DeductionContext(CountryCode.GAB, ElementCode.CODE_CNSS, 2016).calculateEmployee(params) ;
		Double cnamgsAmount = new DeductionContext(CountryCode.GAB, ElementCode.CODE_CNAMGS, 2016).calculateEmployee(params) ;
		
		Double advantagesInKindBasis = grossSalary - article91BisItemsAmount - cnssAmount - cnamgsAmount ;
		
		Double advantagesInKindAmount =  advantagesInKind.entrySet()
				.stream()
				.filter(entry -> {
					return Arrays.asList(ADVANTAGES_IN_KIND).contains(entry.getKey()) ;   
				})
				.mapToDouble(entry -> {
					return switch(entry.getKey()) {
								case CODE_ACCOMODATION :
									yield 0.06 * advantagesInKindBasis ;
								case CODE_DOMESTIC, CODE_WATER, CODE_ELECTRICITY :
									yield 0.05 * advantagesInKindBasis ;
								case CODE_FOOD :
									yield 0.25 * advantagesInKindBasis ;
								default:
									yield 0.0 ;
						} ;
				})
				.sum() ;
		
		Double taxableSalary = params.entrySet()
					.stream()
					.filter(entry -> {
						int key = Integer.parseInt(entry.getKey()) ;
					 	boolean all = key >= 200 && key <= 369 ;
					 	return all && ! Arrays.asList(REFUNDED_ITEMS).contains(entry.getKey()) ;
					})
					.mapToDouble(entry -> {
						return switch(entry.getKey()) {
							case CODE_RETIREMENT_ALLOWANCE :
								yield 0.5 * Double.parseDouble(entry.getValue().toString()) ;
							default:
								yield Double.parseDouble(entry.getValue().toString()) ;
						} ;
					})
					.sum() ;

		return taxableSalary + advantagesInKindAmount ;
	}

	
	public CountryCode country() {
		return CountryCode.GAB ;
	}

	
	public String code() {
		return CODE_CONTRIB_SALARY ;
	}

	
	public int version() {
		return 2016 ;
	}
	
	
	// Exempted
	private static final String[] ARTICLES_91BIS_ITEMS = new String[] { CODE_REPRESENTATION_ALLOWANCE, CODE_RESPONSIBILITY_ALLOWANCE, 
			CODE_TRAVEL_ALLOWANCE, CODE_CASH_BONUS, CODE_CLOTHES_ALLOWANCE, CODE_MISSION_ALLOWANCE, CODE_VEHICLE_ALLOWANCE, 
			CODE_VEHICLE_MAINTENANCE_ALLOWANCE, CODE_TRANSPORT_ALLOWANCE } ;
	
	private static final String[] ADVANTAGES_IN_KIND = new String[] { CODE_ACCOMODATION, CODE_DOMESTIC, CODE_WATER, CODE_ELECTRICITY, 
			CODE_FOOD } ;
	
	private static final String[] REFUNDED_ITEMS = new String[] { CODE_TRAVEL_ALLOWANCE, CODE_VEHICLE_MAINTENANCE_ALLOWANCE, 
			CODE_CASH_ALLOWANCE, CODE_TRIP_ALLOWANCE, CODE_MISSION_ALLOWANCE, CODE_LAUNDRY_ALLOWANCE, CODE_MEAL_ALLOWANCE,
			CODE_SHOPPING_CART_BONUS, CODE_FUEL_ALLOWANCE, CODE_COLD_ALLOWANCE, CODE_HOT_ALLOWANCE, CODE_SCHOOL_FEES_ALLOWANCE,
			CODE_GOOD_SEPARATION_ALLOWANCE, CODE_VOLUNTARY_DEPART_ALLOWANCE, CODE_COMPANY_COMITTEE_ALLOWANCE, CODE_MILEAGE_ALLOWANCE, 
			CODE_DIRTY_BONUS, CODE_CLOTHING_BONUS, CODE_BEAUTY_BONUS, CODE_HAIRDRESSING_BONUS, CODE_TRAINING_FEES, CODE_UNSANITARY_FEES, 
			CODE_ATTENDANCE_FEES, CODE_SOLIDARITY_BONUS } ;
	
	
}
