package tech.deepdreams.worker.deductionbasis;
import static tech.deepdreams.worker.constants.ElementCode.*;
import static tech.deepdreams.worker.constants.LocalConstantCode.*;
import java.util.Arrays;
import java.util.Map;
import tech.deepdreams.worker.api.services.DeductionBasisService;
import tech.deepdreams.worker.constants.ElementCode;
import tech.deepdreams.worker.constants.LocalConstantCode;
import tech.deepdreams.worker.api.context.DeductionBasisContext;
import tech.deepdreams.worker.api.context.DeductionContext;
import tech.deepdreams.worker.api.enums.CountryCode;

public class AdvantagesInKindSalaryv2022Impl implements DeductionBasisService{

	
	public Double calculate(Map<String, Object> params, Map<String, Integer> advantagesInKind) {
		DeductionBasisContext context = new DeductionBasisContext(CountryCode.GAB, LocalConstantCode.CODE_GROSS_SALARY, 2019) ;
		Double grossSalary = context.calculate(params, advantagesInKind) ;
		
		Double article91BisItemsAmount = params.entrySet()
					.stream()
					.filter(entry -> {
						return Arrays.asList(ARTICLES_91BIS_ITEMS).contains(entry.getKey()) ;   
					})
					.mapToDouble(entry -> {
						return Double.parseDouble(entry.getValue().toString()) ;
					})
					.sum() ;
		
		Double cnssAmount = new DeductionContext(CountryCode.GAB, ElementCode.CODE_CNSS, 2016).calculateEmployee(params) ;
		Double cnamgsAmount = new DeductionContext(CountryCode.GAB, ElementCode.CODE_CNAMGS, 2016).calculateEmployee(params) ;
		
		Double advantagesInKindBasis = grossSalary - article91BisItemsAmount - cnssAmount - cnamgsAmount ;
		
		return advantagesInKind.entrySet()
					.stream()
					.filter(entry -> {
						return Arrays.asList(ADVANTAGES_IN_KIND).contains(entry.getKey()) ;   
					})
					.mapToDouble(entry -> {
					return switch(entry.getKey()) {
									case CODE_ACCOMODATION :
										yield 0.15 * advantagesInKindBasis ;
									case CODE_DOMESTIC, CODE_WATER, CODE_ELECTRICITY :
										yield 0.05 * advantagesInKindBasis ;
									case CODE_FOOD :
										yield 0.25 * advantagesInKindBasis ;
									default:
										yield 0.0 ;
							} ;
					})
					.sum() ;

	}

	
	public CountryCode country() {
		return CountryCode.GAB ;
	}

	
	public String code() {
		return CODE_BENEFITS_IN_KIND ;
	}

	
	public int version() {
		return 2022 ;
	}

	// Exempted
	private static final String[] ARTICLES_91BIS_ITEMS = new String[] { CODE_REPRESENTATION_ALLOWANCE, CODE_RESPONSIBILITY_ALLOWANCE, 
			CODE_TRAVEL_ALLOWANCE, CODE_CASH_BONUS, CODE_CLOTHES_ALLOWANCE, CODE_MISSION_ALLOWANCE, CODE_VEHICLE_ALLOWANCE, 
			CODE_VEHICLE_MAINTENANCE_ALLOWANCE, CODE_TRANSPORT_ALLOWANCE } ;

	private static final String[] ADVANTAGES_IN_KIND = new String[] { CODE_ACCOMODATION, CODE_DOMESTIC, CODE_WATER,
			CODE_ELECTRICITY, CODE_FOOD } ;
	
}
