package tech.deepdreams.worker.deduction;
import java.util.Arrays;
import java.util.Map;
import tech.deepdreams.worker.api.services.DeductionService;
import tech.deepdreams.worker.api.util.CommonCodes;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.constants.ElementCode;
import tech.deepdreams.worker.constants.LocalConstantCode;

public class IRPPServicev2022Impl implements DeductionService{
	private static final Double MAX_TAX_SALARY_REDUCTION = 10_000_000.0/12.0 ;
	
	public Double calculateEmployee(Map<String, Object> params) {
		Double shares = (Double) params.get(CommonCodes.CODE_EMPLOYEE_SHARES) ;
		Double taxableSalary = (Double) params.get(LocalConstantCode.CODE_GROSS_TAXABLE_SALARY) ;
		
		Double incomeTaxBasis = taxableSalary - Math.min(0.2 * taxableSalary, MAX_TAX_SALARY_REDUCTION) ;
		
		Double quotient = incomeTaxBasis / shares ;
		
		int index = Arrays.binarySearch(ranges, 12.0 * quotient) ;
		return (0.001 * rates[index] * quotient -  deductions[index]) * shares / 12.0 ;
	}
	
	
	Double[] ranges = new Double[]{ 1_500_000.0, 1_920_000.0, 2_700_000.0, 3_600_000.0, 5_160_000.0, 7_500_000.0, 11_000_000.0, 999_999_999.0 } ;

	Double[] rates = new Double[]{ 0.0, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0 } ;
	
	Double[] deductions = new Double[]{ 0.0, 75_000.0, 171_000.0, 306_000.0, 486_000.0, 744_000.0, 1_119_000.0, 1_669_000.0 } ;
	
	
	public Double calculateEmployer(Map<String, Object> params) {
		return 0.0 ;
	}
	
	
	public CountryCode country() {
		return CountryCode.GAB ;
	}
	
	
	public String code() {
		return ElementCode.CODE_IRPP ;
	}
	
	
	public int version() {
		return 2022 ;
	}
	
}
