package tech.deepdreams.worker.deduction;
import java.util.Map;
import tech.deepdreams.worker.api.services.DeductionService;
import tech.deepdreams.worker.api.util.CommonCodes;
import tech.deepdreams.worker.api.enums.CountryCode;
import tech.deepdreams.worker.constants.ElementCode;
import tech.deepdreams.worker.constants.LocalConstantCode;

public class CNSSServicev2016Impl implements DeductionService{
	
	
	public Double calculateEmployee(Map<String, Object> params) {
		Double minimumSalary = (Double) params.get(CommonCodes.CODE_SMIG) ;
		Double contribSalary = (Double) params.get(LocalConstantCode.CODE_CONTRIB_SALARY) ;
		return Math.max(Math.min(contribSalary, 1_500_000.0), minimumSalary) * 0.025 ;
	}

	
	public Double calculateEmployer(Map<String, Object> params) {
		Double minimumSalary = (Double) params.get(CommonCodes.CODE_SMIG) ;
		Double contribSalary = (Double) params.get(LocalConstantCode.CODE_CONTRIB_SALARY) ;
		return Math.max(Math.min(contribSalary, 1_500_000.0), minimumSalary) * 0.05 ;
	}
	
	
	public CountryCode country() {
		return CountryCode.GAB ;
	}
	
	
	public String code() {
		return ElementCode.CODE_CNSS ;
	}
	
	
	public int version() {
		return 2016 ;
	}
	
}
