package tech.deepdreams.worker.benefit;
import java.util.Map;
import tech.deepdreams.worker.api.services.SeniorityBonusService;
import tech.deepdreams.worker.constants.ElementCode;
import tech.deepdreams.worker.constants.LocalConstantCode;
import tech.deepdreams.worker.api.enums.CountryCode;

public class SeniorityBonusServicev1994Impl implements SeniorityBonusService{
	
	
	public Double calculate(Map<String, Object> params) {
		Double seniorityYears = (Double) params.get(LocalConstantCode.CODE_YEARS_SENIORITY) ;
		Double baseSalary = (Double) params.get(ElementCode.CODE_BASE_SALARY) ;
		
		if(seniorityYears >= 3.0 && seniorityYears <= 5.0) {
			return baseSalary * 0.03 ;
		} else if(seniorityYears >= 6.0 && seniorityYears <= 10.0) {
			return baseSalary * 0.05 ;
		} else if(seniorityYears >= 11.0 && seniorityYears <= 15.0) {
			return baseSalary * 0.07 ;
		} else if(seniorityYears >= 16.0 && seniorityYears <= 20.0) {
			return baseSalary * 0.10 ;
		} else if(seniorityYears >= 21.0) {
			return baseSalary * 0.15 ;
		}
		
		return 0.0 ;
	}

	
	public CountryCode country() {
		return CountryCode.GAB ;
	}

	
	public int version() {
		return 2020 ;
	}

	
	public String code() {
		return ElementCode.CODE_SENIORITY_BONUS ;
	}
}
