package tech.deepdreams.worker.benefit;
import java.util.Map;
import tech.deepdreams.worker.api.services.HourlySalaryService;
import tech.deepdreams.worker.constants.ElementCode;
import tech.deepdreams.worker.constants.LocalConstantCode;
import tech.deepdreams.worker.api.enums.CountryCode;

public class HourlySalaryServicev2020Impl implements HourlySalaryService{
	

	public Double calculate(Map<String, Object> params) {
		Double requiredWorkingHours = (Double) params.get(LocalConstantCode.CODE_REQUIRED_WORKING_HOURS) ;
		Double baseSalary = (Double) params.get(ElementCode.CODE_BASE_SALARY) ;
		return baseSalary*1.0/requiredWorkingHours ;
	}
	
	
	public CountryCode country() {
		return CountryCode.CIV ;
	}

	
	public int version() {
		return 2020 ;
	}

	
	public String code() {
		return LocalConstantCode.CODE_HOURLY_SALARY ;
	}
	
	// prime d'expatriation, prime d'ancienneté, prime de transport, prime de fin d'année
}
