package tech.deepdreams.worker.api.context;
import java.util.Map;
import java.util.ServiceLoader ;
import java.util.ServiceLoader.Provider;
import tech.deepdreams.worker.api.exceptions.ServiceNotFoundException;
import tech.deepdreams.worker.api.services.SeniorityBonusService;

public class SeniorityBonusContext {
	private SeniorityBonusService seniorityBonusService ;
	
	public SeniorityBonusContext(String countryCode, String code, int version){
		this.seniorityBonusService = ServiceLoader.load(SeniorityBonusService.class)
					 .stream()
					 .map(Provider::get)
					 .filter(service -> service.country().equals(countryCode) && service.code().equals(code) && service.version() == version) 
					 .findAny()
					 .orElseThrow(() -> new ServiceNotFoundException()) ;
	}
	
	
	public Double calculate(Map<String, Object> params) {
		return seniorityBonusService.calculate(params) ;
	}
}
