package tech.deepdreams.worker.api.context;
import java.util.Map;
import java.util.ServiceLoader ;
import java.util.ServiceLoader.Provider;
import tech.deepdreams.worker.api.exceptions.ServiceNotFoundException;
import tech.deepdreams.worker.api.services.HourlySalaryService;

public class HourlySalaryContext {
	private HourlySalaryService hourlySalaryService ;
	
	public HourlySalaryContext(String countryCode, String code, int version){
		this.hourlySalaryService = ServiceLoader.load(HourlySalaryService.class)
					 .stream()
					 .map(Provider::get)
					 .filter(service -> service.country().equals(countryCode) &&  service.code().equals(code) && service.version() == version) 
					 .findAny()
					 .orElseThrow(() -> new ServiceNotFoundException()) ;
	}
	
	
	public Double calculate(Map<String, Object> params) {
		return hourlySalaryService.calculate(params) ;
	}
}
