package tech.deepdreams.worker.api.context;
import java.util.Map;
import java.util.ServiceLoader ;
import java.util.ServiceLoader.Provider;
import tech.deepdreams.worker.api.exceptions.ServiceNotFoundException;
import tech.deepdreams.worker.api.services.DeductionService;

public class DeductionContext {
	private DeductionService deductionService ;
	
	public DeductionContext(String countryCode, String deductionCode, int version){
		this.deductionService = ServiceLoader.load(DeductionService.class)
					 .stream()
					 .map(Provider::get)
					 .filter(service -> service.country().equals(countryCode) && service.deductionCode().equals(deductionCode) && service.version() == version) 
					 .findAny()
					 .orElseThrow(() -> new ServiceNotFoundException()) ;
	}
	
	
	public Double calculateEmployee(Map<String, Object> params) {
		return deductionService.calculateEmployee(params) ;
	}
	
	public Double calculateEmployer(Map<String, Object> params) {
		return deductionService.calculateEmployer(params) ;
	}
}
