package tech.deepdreams.worker.api.context;
import java.util.Map;
import java.util.ServiceLoader ;
import java.util.ServiceLoader.Provider;
import tech.deepdreams.worker.api.exceptions.ServiceNotFoundException;
import tech.deepdreams.worker.api.services.DeductionBasisService;

public class DeductionBasisContext {
	private DeductionBasisService deductionBasisService ;
	
	public DeductionBasisContext(String countryCode, String deductionCode, int version){
		this.deductionBasisService = ServiceLoader.load(DeductionBasisService.class)
					 .stream()
					 .map(Provider::get)
					 .filter(service -> service.country().equals(countryCode) && service.deductionCode().equals(deductionCode) && service.version() == version) 
					 .findAny()
					 .orElseThrow(() -> new ServiceNotFoundException()) ;
	}
	
	
	public Double calculate(Map<String, Object> params) {
		return deductionBasisService.calculate(params) ;
	}
}
