/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.product.service;

import jakarta.transaction.Transactional;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import tech.corefinance.common.ex.ServiceProcessingException;
import tech.corefinance.common.model.CreateUpdateDto;
import tech.corefinance.common.model.GenericModel;
import tech.corefinance.product.dto.RateResponse;
import tech.corefinance.product.entity.Rate;
import tech.corefinance.product.entity.RateSource;
import tech.corefinance.product.repository.RateRepository;
import tech.corefinance.product.repository.RateSourceRepository;
import tech.corefinance.product.service.RateService;

@Service
@Transactional
public class RateServiceImpl
implements RateService {
    @Autowired
    private RateRepository rateRepository;
    @Autowired
    private RateSourceRepository rateSourceRepository;

    public RateRepository getRepository() {
        return this.rateRepository;
    }

    public <D extends CreateUpdateDto<String>> void copyAdditionalPropertiesFromDtoToEntity(D source, Rate dest) {
        RateResponse rateResponse;
        RateService.super.copyAdditionalPropertiesFromDtoToEntity(source, (GenericModel)dest);
        if (source instanceof RateResponse && StringUtils.hasText((String)(rateResponse = (RateResponse)source).getRateSourceId())) {
            Optional optional = this.rateSourceRepository.findById(rateResponse.getRateSourceId());
            dest.setRateSource((RateSource)optional.orElseThrow(() -> new ServiceProcessingException("rate_source_not_found")));
        }
    }
}

