/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.product.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.corefinance.common.context.TenantContext;
import tech.corefinance.common.ex.ServiceProcessingException;
import tech.corefinance.common.model.CreateUpdateDto;
import tech.corefinance.common.model.GenericModel;
import tech.corefinance.product.entity.Branch;
import tech.corefinance.product.entity.Organization;
import tech.corefinance.product.repository.BranchRepository;
import tech.corefinance.product.repository.OrganizationRepository;
import tech.corefinance.product.service.BranchService;

@Service
@Transactional
public class BranchServiceImpl
implements BranchService {
    private static final Logger log = LoggerFactory.getLogger(BranchServiceImpl.class);
    @Autowired
    private BranchRepository branchRepository;
    @Autowired
    private OrganizationRepository organizationRepository;

    public BranchRepository getRepository() {
        return this.branchRepository;
    }

    public <D extends CreateUpdateDto<String>> void copyAdditionalPropertiesFromDtoToEntity(D source, Branch dest) {
        BranchService.super.copyAdditionalPropertiesFromDtoToEntity(source, (GenericModel)dest);
        TenantContext tenantContext = TenantContext.getInstance();
        String currentTenant = tenantContext.getTenantId();
        log.debug("Current tenant [{}]", (Object)currentTenant);
        if (dest.isInheritNonWorkingDays()) {
            ErrorHolder errorMarker = new ErrorHolder(null);
            Thread thread = new Thread(() -> {
                try {
                    tenantContext.clearTenantId();
                    Organization org = (Organization)this.organizationRepository.findById(currentTenant).orElseThrow(() -> new ServiceProcessingException("organization_not_found"));
                    dest.setNonWorkingDays(org.getNonWorkingDays());
                }
                catch (Throwable e) {
                    errorMarker.value = e;
                }
                finally {
                    tenantContext.setTenantId(currentTenant);
                }
            });
            thread.start();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                errorMarker.value = e;
            }
            if (errorMarker.value != null) {
                Throwable throwable = errorMarker.value;
                if (throwable instanceof RuntimeException) {
                    RuntimeException runtimeEx = (RuntimeException)throwable;
                    throw runtimeEx;
                }
                throw new ServiceProcessingException("organization_load_error", errorMarker.value);
            }
        }
    }

    private static class ErrorHolder {
        Throwable value;

        ErrorHolder(Throwable value) {
            this.value = value;
        }
    }
}

