/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.product.filter;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import tech.corefinance.common.context.TenantContext;
import tech.corefinance.common.controller.ResourceActionController;
import tech.corefinance.product.controller.CurrencyController;
import tech.corefinance.product.controller.OrganizationController;

@Component
public class TenantIgnoreFilter
implements Filter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(TenantIgnoreFilter.class);
    private static List<Class<?>> controllerToIgnoreTenant = List.of(OrganizationController.class, CurrencyController.class, ResourceActionController.class);
    private List<String> listApplyUrls = new LinkedList<String>();

    @PostConstruct
    public void postConstruct() {
        controllerToIgnoreTenant.forEach(c -> {
            String[] values = c.getAnnotation(RequestMapping.class).value();
            this.listApplyUrls.addAll(List.of(values));
        });
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestUri = ((HttpServletRequest)request).getRequestURI();
        TenantContext tenantContext = TenantContext.getInstance();
        String currentTenant = tenantContext.getTenantId();
        log.debug("Current tenant [{}]", (Object)currentTenant);
        boolean isCallingOrganization = this.shouldIgnore(requestUri);
        try {
            if (isCallingOrganization) {
                log.debug("Clear tenant info for Organization service");
                TenantContext.getInstance().clearTenantId();
            }
            chain.doFilter(request, response);
        }
        finally {
            if (isCallingOrganization) {
                log.debug("Restore tenant [{}]", (Object)currentTenant);
                tenantContext.setTenantId(currentTenant);
            }
        }
    }

    private boolean shouldIgnore(String requestUri) {
        for (String url : this.listApplyUrls) {
            if (!requestUri.startsWith(url)) continue;
            return true;
        }
        return false;
    }
}

