/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.product.entity;

import jakarta.persistence.Column;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.hibernate.annotations.JdbcTypeCode;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import tech.corefinance.common.audit.EntityBasicUserAuditorListener;
import tech.corefinance.common.audit.EntityDeleteListener;
import tech.corefinance.common.audit.EntityZonedDateTimeAuditListener;
import tech.corefinance.common.dto.BasicUserDto;
import tech.corefinance.common.model.AuditableEntity;
import tech.corefinance.common.model.GenericModel;
import tech.corefinance.common.model.ModifiedDateTrackedEntity;
import tech.corefinance.product.model.ProductAvailability;
import tech.corefinance.product.model.ProductFee;
import tech.corefinance.product.model.ProductNewAccountSetting;

@MappedSuperclass
@EntityListeners(value={EntityBasicUserAuditorListener.class, EntityZonedDateTimeAuditListener.class, EntityDeleteListener.class})
public abstract class Product
implements GenericModel<String>,
AuditableEntity<BasicUserDto>,
ModifiedDateTrackedEntity<ZonedDateTime> {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private String id;
    @NotBlank(message="product_name_empty")
    private @NotBlank(message="product_name_empty") String name;
    @NotBlank(message="product_category_empty")
    private @NotBlank(message="product_category_empty") String category;
    private String type;
    private String description;
    private boolean activated;
    @JdbcTypeCode(value=3001)
    @Column(name="product_availabilities")
    private List<ProductAvailability> productAvailabilities;
    @NotNull(message="new_account_type_empty")
    @JdbcTypeCode(value=3001)
    @Column(name="new_account_setting")
    private @NotNull(message="new_account_type_empty") ProductNewAccountSetting newAccountSetting;
    @NotNull(message="currencies_empty")
    private @NotNull(message="currencies_empty") String[] currencies;
    @Column(name="allow_arbitrary_fees")
    private boolean allowArbitraryFees;
    @Column(name="show_inactive_fees")
    private boolean showInactiveFees;
    @JdbcTypeCode(value=3001)
    @Column(name="product_fees")
    private List<ProductFee> productFees;
    @CreatedDate
    @Column(name="created_date")
    private ZonedDateTime createdDate;
    @CreatedBy
    @Column(name="created_by")
    @JdbcTypeCode(value=3001)
    private BasicUserDto createdBy;
    @LastModifiedDate
    @Column(name="last_modified_date")
    private ZonedDateTime lastModifiedDate;
    @CreatedBy
    @Column(name="last_modified_by")
    @JdbcTypeCode(value=3001)
    private BasicUserDto lastModifiedBy;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public List<ProductAvailability> getProductAvailabilities() {
        return this.productAvailabilities;
    }

    public ProductNewAccountSetting getNewAccountSetting() {
        return this.newAccountSetting;
    }

    public String[] getCurrencies() {
        return this.currencies;
    }

    public boolean isAllowArbitraryFees() {
        return this.allowArbitraryFees;
    }

    public boolean isShowInactiveFees() {
        return this.showInactiveFees;
    }

    public List<ProductFee> getProductFees() {
        return this.productFees;
    }

    public ZonedDateTime getCreatedDate() {
        return this.createdDate;
    }

    public BasicUserDto getCreatedBy() {
        return this.createdBy;
    }

    public ZonedDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public BasicUserDto getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public void setProductAvailabilities(List<ProductAvailability> productAvailabilities) {
        this.productAvailabilities = productAvailabilities;
    }

    public void setNewAccountSetting(ProductNewAccountSetting newAccountSetting) {
        this.newAccountSetting = newAccountSetting;
    }

    public void setCurrencies(String[] currencies) {
        this.currencies = currencies;
    }

    public void setAllowArbitraryFees(boolean allowArbitraryFees) {
        this.allowArbitraryFees = allowArbitraryFees;
    }

    public void setShowInactiveFees(boolean showInactiveFees) {
        this.showInactiveFees = showInactiveFees;
    }

    public void setProductFees(List<ProductFee> productFees) {
        this.productFees = productFees;
    }

    public void setCreatedDate(ZonedDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public void setCreatedBy(BasicUserDto createdBy) {
        this.createdBy = createdBy;
    }

    public void setLastModifiedDate(ZonedDateTime lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setLastModifiedBy(BasicUserDto lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Product)) {
            return false;
        }
        Product other = (Product)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isActivated() != other.isActivated()) {
            return false;
        }
        if (this.isAllowArbitraryFees() != other.isAllowArbitraryFees()) {
            return false;
        }
        if (this.isShowInactiveFees() != other.isShowInactiveFees()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<ProductAvailability> this$productAvailabilities = this.getProductAvailabilities();
        List<ProductAvailability> other$productAvailabilities = other.getProductAvailabilities();
        if (this$productAvailabilities == null ? other$productAvailabilities != null : !((Object)this$productAvailabilities).equals(other$productAvailabilities)) {
            return false;
        }
        ProductNewAccountSetting this$newAccountSetting = this.getNewAccountSetting();
        ProductNewAccountSetting other$newAccountSetting = other.getNewAccountSetting();
        if (this$newAccountSetting == null ? other$newAccountSetting != null : !((Object)this$newAccountSetting).equals(other$newAccountSetting)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCurrencies(), other.getCurrencies())) {
            return false;
        }
        List<ProductFee> this$productFees = this.getProductFees();
        List<ProductFee> other$productFees = other.getProductFees();
        if (this$productFees == null ? other$productFees != null : !((Object)this$productFees).equals(other$productFees)) {
            return false;
        }
        ZonedDateTime this$createdDate = this.getCreatedDate();
        ZonedDateTime other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        BasicUserDto this$createdBy = this.getCreatedBy();
        BasicUserDto other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        ZonedDateTime this$lastModifiedDate = this.getLastModifiedDate();
        ZonedDateTime other$lastModifiedDate = other.getLastModifiedDate();
        if (this$lastModifiedDate == null ? other$lastModifiedDate != null : !((Object)this$lastModifiedDate).equals(other$lastModifiedDate)) {
            return false;
        }
        BasicUserDto this$lastModifiedBy = this.getLastModifiedBy();
        BasicUserDto other$lastModifiedBy = other.getLastModifiedBy();
        return !(this$lastModifiedBy == null ? other$lastModifiedBy != null : !this$lastModifiedBy.equals(other$lastModifiedBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Product;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isActivated() ? 79 : 97);
        result = result * 59 + (this.isAllowArbitraryFees() ? 79 : 97);
        result = result * 59 + (this.isShowInactiveFees() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<ProductAvailability> $productAvailabilities = this.getProductAvailabilities();
        result = result * 59 + ($productAvailabilities == null ? 43 : ((Object)$productAvailabilities).hashCode());
        ProductNewAccountSetting $newAccountSetting = this.getNewAccountSetting();
        result = result * 59 + ($newAccountSetting == null ? 43 : ((Object)$newAccountSetting).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCurrencies());
        List<ProductFee> $productFees = this.getProductFees();
        result = result * 59 + ($productFees == null ? 43 : ((Object)$productFees).hashCode());
        ZonedDateTime $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        BasicUserDto $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        ZonedDateTime $lastModifiedDate = this.getLastModifiedDate();
        result = result * 59 + ($lastModifiedDate == null ? 43 : ((Object)$lastModifiedDate).hashCode());
        BasicUserDto $lastModifiedBy = this.getLastModifiedBy();
        result = result * 59 + ($lastModifiedBy == null ? 43 : $lastModifiedBy.hashCode());
        return result;
    }

    public String toString() {
        return "Product(id=" + this.getId() + ", name=" + this.getName() + ", category=" + this.getCategory() + ", type=" + this.getType() + ", description=" + this.getDescription() + ", activated=" + this.isActivated() + ", productAvailabilities=" + this.getProductAvailabilities() + ", newAccountSetting=" + this.getNewAccountSetting() + ", currencies=" + Arrays.deepToString(this.getCurrencies()) + ", allowArbitraryFees=" + this.isAllowArbitraryFees() + ", showInactiveFees=" + this.isShowInactiveFees() + ", productFees=" + this.getProductFees() + ", createdDate=" + this.getCreatedDate() + ", createdBy=" + this.getCreatedBy() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", lastModifiedBy=" + this.getLastModifiedBy() + ")";
    }
}

