/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.product.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Table;
import java.util.List;
import org.hibernate.annotations.JdbcTypeCode;
import tech.corefinance.product.entity.Product;
import tech.corefinance.product.enums.CreditArrangementManaged;
import tech.corefinance.product.enums.FrequencyOptionYearly;
import tech.corefinance.product.model.CurrencyLimitValue;
import tech.corefinance.product.model.DepositInterestRate;
import tech.corefinance.product.model.DepositLimit;
import tech.corefinance.product.model.WithdrawalLimit;

@Entity
@Table(name="deposit_product")
public class DepositProduct
extends Product {
    @JdbcTypeCode(value=3001)
    @Column(name="interest_rate")
    private DepositInterestRate interestRate;
    @Column(name="days_to_set_to_dormant")
    private Integer daysToSetToDormant;
    @JdbcTypeCode(value=3001)
    @Column(name="deposit_limits")
    private List<DepositLimit> depositLimits;
    @JdbcTypeCode(value=3001)
    @Column(name="withdrawal_limits")
    private List<WithdrawalLimit> withdrawalLimits;
    @JdbcTypeCode(value=3001)
    @Column(name="early_closure_period")
    private Integer earlyClosurePeriod;
    @Column(name="allow_overdrafts")
    private Boolean allowOverdrafts;
    @JdbcTypeCode(value=3001)
    @Column(name="overdrafts_interest")
    private DepositInterestRate overdraftsInterest;
    @JdbcTypeCode(value=3001)
    @Column(name="max_overdraft_limit")
    private List<CurrencyLimitValue> maxOverdraftLimit;
    @Enumerated(value=EnumType.STRING)
    @Column(name="overdrafts_under_credit_arrangement_managed")
    private CreditArrangementManaged overdraftsUnderCreditArrangementManaged;
    @Column(name="enable_term_deposit")
    private boolean enableTermDeposit;
    @Enumerated(value=EnumType.STRING)
    @Column(name="term_unit")
    private FrequencyOptionYearly termUnit;
    @Column(name="min_term_length")
    private Integer minTermLength;
    @Column(name="max_term_length")
    private Integer maxTermLength;
    @Column(name="default_term_length")
    private Integer defaultTermLength;

    public DepositInterestRate getInterestRate() {
        return this.interestRate;
    }

    public Integer getDaysToSetToDormant() {
        return this.daysToSetToDormant;
    }

    public List<DepositLimit> getDepositLimits() {
        return this.depositLimits;
    }

    public List<WithdrawalLimit> getWithdrawalLimits() {
        return this.withdrawalLimits;
    }

    public Integer getEarlyClosurePeriod() {
        return this.earlyClosurePeriod;
    }

    public Boolean getAllowOverdrafts() {
        return this.allowOverdrafts;
    }

    public DepositInterestRate getOverdraftsInterest() {
        return this.overdraftsInterest;
    }

    public List<CurrencyLimitValue> getMaxOverdraftLimit() {
        return this.maxOverdraftLimit;
    }

    public CreditArrangementManaged getOverdraftsUnderCreditArrangementManaged() {
        return this.overdraftsUnderCreditArrangementManaged;
    }

    public boolean isEnableTermDeposit() {
        return this.enableTermDeposit;
    }

    public FrequencyOptionYearly getTermUnit() {
        return this.termUnit;
    }

    public Integer getMinTermLength() {
        return this.minTermLength;
    }

    public Integer getMaxTermLength() {
        return this.maxTermLength;
    }

    public Integer getDefaultTermLength() {
        return this.defaultTermLength;
    }

    public void setInterestRate(DepositInterestRate interestRate) {
        this.interestRate = interestRate;
    }

    public void setDaysToSetToDormant(Integer daysToSetToDormant) {
        this.daysToSetToDormant = daysToSetToDormant;
    }

    public void setDepositLimits(List<DepositLimit> depositLimits) {
        this.depositLimits = depositLimits;
    }

    public void setWithdrawalLimits(List<WithdrawalLimit> withdrawalLimits) {
        this.withdrawalLimits = withdrawalLimits;
    }

    public void setEarlyClosurePeriod(Integer earlyClosurePeriod) {
        this.earlyClosurePeriod = earlyClosurePeriod;
    }

    public void setAllowOverdrafts(Boolean allowOverdrafts) {
        this.allowOverdrafts = allowOverdrafts;
    }

    public void setOverdraftsInterest(DepositInterestRate overdraftsInterest) {
        this.overdraftsInterest = overdraftsInterest;
    }

    public void setMaxOverdraftLimit(List<CurrencyLimitValue> maxOverdraftLimit) {
        this.maxOverdraftLimit = maxOverdraftLimit;
    }

    public void setOverdraftsUnderCreditArrangementManaged(CreditArrangementManaged overdraftsUnderCreditArrangementManaged) {
        this.overdraftsUnderCreditArrangementManaged = overdraftsUnderCreditArrangementManaged;
    }

    public void setEnableTermDeposit(boolean enableTermDeposit) {
        this.enableTermDeposit = enableTermDeposit;
    }

    public void setTermUnit(FrequencyOptionYearly termUnit) {
        this.termUnit = termUnit;
    }

    public void setMinTermLength(Integer minTermLength) {
        this.minTermLength = minTermLength;
    }

    public void setMaxTermLength(Integer maxTermLength) {
        this.maxTermLength = maxTermLength;
    }

    public void setDefaultTermLength(Integer defaultTermLength) {
        this.defaultTermLength = defaultTermLength;
    }

    @Override
    public String toString() {
        return "DepositProduct(interestRate=" + this.getInterestRate() + ", daysToSetToDormant=" + this.getDaysToSetToDormant() + ", depositLimits=" + this.getDepositLimits() + ", withdrawalLimits=" + this.getWithdrawalLimits() + ", earlyClosurePeriod=" + this.getEarlyClosurePeriod() + ", allowOverdrafts=" + this.getAllowOverdrafts() + ", overdraftsInterest=" + this.getOverdraftsInterest() + ", maxOverdraftLimit=" + this.getMaxOverdraftLimit() + ", overdraftsUnderCreditArrangementManaged=" + this.getOverdraftsUnderCreditArrangementManaged() + ", enableTermDeposit=" + this.isEnableTermDeposit() + ", termUnit=" + this.getTermUnit() + ", minTermLength=" + this.getMinTermLength() + ", maxTermLength=" + this.getMaxTermLength() + ", defaultTermLength=" + this.getDefaultTermLength() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DepositProduct)) {
            return false;
        }
        DepositProduct other = (DepositProduct)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnableTermDeposit() != other.isEnableTermDeposit()) {
            return false;
        }
        Integer this$daysToSetToDormant = this.getDaysToSetToDormant();
        Integer other$daysToSetToDormant = other.getDaysToSetToDormant();
        if (this$daysToSetToDormant == null ? other$daysToSetToDormant != null : !((Object)this$daysToSetToDormant).equals(other$daysToSetToDormant)) {
            return false;
        }
        Integer this$earlyClosurePeriod = this.getEarlyClosurePeriod();
        Integer other$earlyClosurePeriod = other.getEarlyClosurePeriod();
        if (this$earlyClosurePeriod == null ? other$earlyClosurePeriod != null : !((Object)this$earlyClosurePeriod).equals(other$earlyClosurePeriod)) {
            return false;
        }
        Boolean this$allowOverdrafts = this.getAllowOverdrafts();
        Boolean other$allowOverdrafts = other.getAllowOverdrafts();
        if (this$allowOverdrafts == null ? other$allowOverdrafts != null : !((Object)this$allowOverdrafts).equals(other$allowOverdrafts)) {
            return false;
        }
        Integer this$minTermLength = this.getMinTermLength();
        Integer other$minTermLength = other.getMinTermLength();
        if (this$minTermLength == null ? other$minTermLength != null : !((Object)this$minTermLength).equals(other$minTermLength)) {
            return false;
        }
        Integer this$maxTermLength = this.getMaxTermLength();
        Integer other$maxTermLength = other.getMaxTermLength();
        if (this$maxTermLength == null ? other$maxTermLength != null : !((Object)this$maxTermLength).equals(other$maxTermLength)) {
            return false;
        }
        Integer this$defaultTermLength = this.getDefaultTermLength();
        Integer other$defaultTermLength = other.getDefaultTermLength();
        if (this$defaultTermLength == null ? other$defaultTermLength != null : !((Object)this$defaultTermLength).equals(other$defaultTermLength)) {
            return false;
        }
        DepositInterestRate this$interestRate = this.getInterestRate();
        DepositInterestRate other$interestRate = other.getInterestRate();
        if (this$interestRate == null ? other$interestRate != null : !((Object)this$interestRate).equals(other$interestRate)) {
            return false;
        }
        List<DepositLimit> this$depositLimits = this.getDepositLimits();
        List<DepositLimit> other$depositLimits = other.getDepositLimits();
        if (this$depositLimits == null ? other$depositLimits != null : !((Object)this$depositLimits).equals(other$depositLimits)) {
            return false;
        }
        List<WithdrawalLimit> this$withdrawalLimits = this.getWithdrawalLimits();
        List<WithdrawalLimit> other$withdrawalLimits = other.getWithdrawalLimits();
        if (this$withdrawalLimits == null ? other$withdrawalLimits != null : !((Object)this$withdrawalLimits).equals(other$withdrawalLimits)) {
            return false;
        }
        DepositInterestRate this$overdraftsInterest = this.getOverdraftsInterest();
        DepositInterestRate other$overdraftsInterest = other.getOverdraftsInterest();
        if (this$overdraftsInterest == null ? other$overdraftsInterest != null : !((Object)this$overdraftsInterest).equals(other$overdraftsInterest)) {
            return false;
        }
        List<CurrencyLimitValue> this$maxOverdraftLimit = this.getMaxOverdraftLimit();
        List<CurrencyLimitValue> other$maxOverdraftLimit = other.getMaxOverdraftLimit();
        if (this$maxOverdraftLimit == null ? other$maxOverdraftLimit != null : !((Object)this$maxOverdraftLimit).equals(other$maxOverdraftLimit)) {
            return false;
        }
        CreditArrangementManaged this$overdraftsUnderCreditArrangementManaged = this.getOverdraftsUnderCreditArrangementManaged();
        CreditArrangementManaged other$overdraftsUnderCreditArrangementManaged = other.getOverdraftsUnderCreditArrangementManaged();
        if (this$overdraftsUnderCreditArrangementManaged == null ? other$overdraftsUnderCreditArrangementManaged != null : !((Object)((Object)this$overdraftsUnderCreditArrangementManaged)).equals((Object)other$overdraftsUnderCreditArrangementManaged)) {
            return false;
        }
        FrequencyOptionYearly this$termUnit = this.getTermUnit();
        FrequencyOptionYearly other$termUnit = other.getTermUnit();
        return !(this$termUnit == null ? other$termUnit != null : !((Object)((Object)this$termUnit)).equals((Object)other$termUnit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DepositProduct;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnableTermDeposit() ? 79 : 97);
        Integer $daysToSetToDormant = this.getDaysToSetToDormant();
        result = result * 59 + ($daysToSetToDormant == null ? 43 : ((Object)$daysToSetToDormant).hashCode());
        Integer $earlyClosurePeriod = this.getEarlyClosurePeriod();
        result = result * 59 + ($earlyClosurePeriod == null ? 43 : ((Object)$earlyClosurePeriod).hashCode());
        Boolean $allowOverdrafts = this.getAllowOverdrafts();
        result = result * 59 + ($allowOverdrafts == null ? 43 : ((Object)$allowOverdrafts).hashCode());
        Integer $minTermLength = this.getMinTermLength();
        result = result * 59 + ($minTermLength == null ? 43 : ((Object)$minTermLength).hashCode());
        Integer $maxTermLength = this.getMaxTermLength();
        result = result * 59 + ($maxTermLength == null ? 43 : ((Object)$maxTermLength).hashCode());
        Integer $defaultTermLength = this.getDefaultTermLength();
        result = result * 59 + ($defaultTermLength == null ? 43 : ((Object)$defaultTermLength).hashCode());
        DepositInterestRate $interestRate = this.getInterestRate();
        result = result * 59 + ($interestRate == null ? 43 : ((Object)$interestRate).hashCode());
        List<DepositLimit> $depositLimits = this.getDepositLimits();
        result = result * 59 + ($depositLimits == null ? 43 : ((Object)$depositLimits).hashCode());
        List<WithdrawalLimit> $withdrawalLimits = this.getWithdrawalLimits();
        result = result * 59 + ($withdrawalLimits == null ? 43 : ((Object)$withdrawalLimits).hashCode());
        DepositInterestRate $overdraftsInterest = this.getOverdraftsInterest();
        result = result * 59 + ($overdraftsInterest == null ? 43 : ((Object)$overdraftsInterest).hashCode());
        List<CurrencyLimitValue> $maxOverdraftLimit = this.getMaxOverdraftLimit();
        result = result * 59 + ($maxOverdraftLimit == null ? 43 : ((Object)$maxOverdraftLimit).hashCode());
        CreditArrangementManaged $overdraftsUnderCreditArrangementManaged = this.getOverdraftsUnderCreditArrangementManaged();
        result = result * 59 + ($overdraftsUnderCreditArrangementManaged == null ? 43 : ((Object)((Object)$overdraftsUnderCreditArrangementManaged)).hashCode());
        FrequencyOptionYearly $termUnit = this.getTermUnit();
        result = result * 59 + ($termUnit == null ? 43 : ((Object)((Object)$termUnit)).hashCode());
        return result;
    }
}

