/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.product.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.DayOfWeek;
import java.time.ZonedDateTime;
import java.util.List;
import org.hibernate.annotations.JdbcTypeCode;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import tech.corefinance.common.audit.EntityBasicUserAuditorListener;
import tech.corefinance.common.audit.EntityDeleteListener;
import tech.corefinance.common.audit.EntityZonedDateTimeAuditListener;
import tech.corefinance.common.dto.BasicUserDto;
import tech.corefinance.common.model.AuditableEntity;
import tech.corefinance.common.model.CreateUpdateDto;
import tech.corefinance.common.model.GenericModel;
import tech.corefinance.common.model.ModifiedDateTrackedEntity;

@Entity
@Table(name="branch")
@EntityListeners(value={EntityBasicUserAuditorListener.class, EntityZonedDateTimeAuditListener.class, EntityDeleteListener.class})
public class Branch
implements GenericModel<String>,
CreateUpdateDto<String>,
AuditableEntity<BasicUserDto>,
ModifiedDateTrackedEntity<ZonedDateTime> {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private String id;
    private String name;
    @Column(name="street_address_line_1")
    private String streetAddressLine1;
    private String city;
    private String state;
    @Column(name="zip_postal_code")
    private String zipPostalCode;
    private String country;
    @Column(name="phone_number")
    private String phoneNumber;
    private String email;
    @Column(name="parent_branch_id")
    private String parentBranchId;
    @Column(name="non_working_days")
    @JdbcTypeCode(value=3001)
    private List<DayOfWeek> nonWorkingDays = List.of(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    @Column(name="inherit_non_working_days")
    private boolean inheritNonWorkingDays;
    @CreatedDate
    @Column(name="created_date")
    private ZonedDateTime createdDate;
    @CreatedBy
    @Column(name="created_by")
    @JdbcTypeCode(value=3001)
    private BasicUserDto createdBy;
    @LastModifiedDate
    @Column(name="last_modified_date")
    private ZonedDateTime lastModifiedDate;
    @CreatedBy
    @Column(name="last_modified_by")
    @JdbcTypeCode(value=3001)
    private BasicUserDto lastModifiedBy;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getStreetAddressLine1() {
        return this.streetAddressLine1;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getZipPostalCode() {
        return this.zipPostalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public String getParentBranchId() {
        return this.parentBranchId;
    }

    public List<DayOfWeek> getNonWorkingDays() {
        return this.nonWorkingDays;
    }

    public boolean isInheritNonWorkingDays() {
        return this.inheritNonWorkingDays;
    }

    public ZonedDateTime getCreatedDate() {
        return this.createdDate;
    }

    public BasicUserDto getCreatedBy() {
        return this.createdBy;
    }

    public ZonedDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public BasicUserDto getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStreetAddressLine1(String streetAddressLine1) {
        this.streetAddressLine1 = streetAddressLine1;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setZipPostalCode(String zipPostalCode) {
        this.zipPostalCode = zipPostalCode;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setParentBranchId(String parentBranchId) {
        this.parentBranchId = parentBranchId;
    }

    public void setNonWorkingDays(List<DayOfWeek> nonWorkingDays) {
        this.nonWorkingDays = nonWorkingDays;
    }

    public void setInheritNonWorkingDays(boolean inheritNonWorkingDays) {
        this.inheritNonWorkingDays = inheritNonWorkingDays;
    }

    public void setCreatedDate(ZonedDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public void setCreatedBy(BasicUserDto createdBy) {
        this.createdBy = createdBy;
    }

    public void setLastModifiedDate(ZonedDateTime lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setLastModifiedBy(BasicUserDto lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Branch)) {
            return false;
        }
        Branch other = (Branch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isInheritNonWorkingDays() != other.isInheritNonWorkingDays()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$streetAddressLine1 = this.getStreetAddressLine1();
        String other$streetAddressLine1 = other.getStreetAddressLine1();
        if (this$streetAddressLine1 == null ? other$streetAddressLine1 != null : !this$streetAddressLine1.equals(other$streetAddressLine1)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$zipPostalCode = this.getZipPostalCode();
        String other$zipPostalCode = other.getZipPostalCode();
        if (this$zipPostalCode == null ? other$zipPostalCode != null : !this$zipPostalCode.equals(other$zipPostalCode)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$phoneNumber = this.getPhoneNumber();
        String other$phoneNumber = other.getPhoneNumber();
        if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$parentBranchId = this.getParentBranchId();
        String other$parentBranchId = other.getParentBranchId();
        if (this$parentBranchId == null ? other$parentBranchId != null : !this$parentBranchId.equals(other$parentBranchId)) {
            return false;
        }
        List<DayOfWeek> this$nonWorkingDays = this.getNonWorkingDays();
        List<DayOfWeek> other$nonWorkingDays = other.getNonWorkingDays();
        if (this$nonWorkingDays == null ? other$nonWorkingDays != null : !((Object)this$nonWorkingDays).equals(other$nonWorkingDays)) {
            return false;
        }
        ZonedDateTime this$createdDate = this.getCreatedDate();
        ZonedDateTime other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        BasicUserDto this$createdBy = this.getCreatedBy();
        BasicUserDto other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        ZonedDateTime this$lastModifiedDate = this.getLastModifiedDate();
        ZonedDateTime other$lastModifiedDate = other.getLastModifiedDate();
        if (this$lastModifiedDate == null ? other$lastModifiedDate != null : !((Object)this$lastModifiedDate).equals(other$lastModifiedDate)) {
            return false;
        }
        BasicUserDto this$lastModifiedBy = this.getLastModifiedBy();
        BasicUserDto other$lastModifiedBy = other.getLastModifiedBy();
        return !(this$lastModifiedBy == null ? other$lastModifiedBy != null : !this$lastModifiedBy.equals(other$lastModifiedBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Branch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInheritNonWorkingDays() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $streetAddressLine1 = this.getStreetAddressLine1();
        result = result * 59 + ($streetAddressLine1 == null ? 43 : $streetAddressLine1.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $zipPostalCode = this.getZipPostalCode();
        result = result * 59 + ($zipPostalCode == null ? 43 : $zipPostalCode.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $phoneNumber = this.getPhoneNumber();
        result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $parentBranchId = this.getParentBranchId();
        result = result * 59 + ($parentBranchId == null ? 43 : $parentBranchId.hashCode());
        List<DayOfWeek> $nonWorkingDays = this.getNonWorkingDays();
        result = result * 59 + ($nonWorkingDays == null ? 43 : ((Object)$nonWorkingDays).hashCode());
        ZonedDateTime $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        BasicUserDto $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        ZonedDateTime $lastModifiedDate = this.getLastModifiedDate();
        result = result * 59 + ($lastModifiedDate == null ? 43 : ((Object)$lastModifiedDate).hashCode());
        BasicUserDto $lastModifiedBy = this.getLastModifiedBy();
        result = result * 59 + ($lastModifiedBy == null ? 43 : $lastModifiedBy.hashCode());
        return result;
    }

    public String toString() {
        return "Branch(id=" + this.getId() + ", name=" + this.getName() + ", streetAddressLine1=" + this.getStreetAddressLine1() + ", city=" + this.getCity() + ", state=" + this.getState() + ", zipPostalCode=" + this.getZipPostalCode() + ", country=" + this.getCountry() + ", phoneNumber=" + this.getPhoneNumber() + ", email=" + this.getEmail() + ", parentBranchId=" + this.getParentBranchId() + ", nonWorkingDays=" + this.getNonWorkingDays() + ", inheritNonWorkingDays=" + this.isInheritNonWorkingDays() + ", createdDate=" + this.getCreatedDate() + ", createdBy=" + this.getCreatedBy() + ", lastModifiedDate=" + this.getLastModifiedDate() + ", lastModifiedBy=" + this.getLastModifiedBy() + ")";
    }
}

