/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.product.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.ZonedDateTime;
import org.hibernate.annotations.JdbcTypeCode;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import tech.corefinance.common.audit.AuditableEntity;
import tech.corefinance.common.audit.EntityBasicUserAuditorListener;
import tech.corefinance.common.audit.EntityDeleteListener;
import tech.corefinance.common.audit.EntityZonedDateTimeAuditListener;
import tech.corefinance.common.dto.BasicUserDto;
import tech.corefinance.common.model.CreateUpdateDto;
import tech.corefinance.common.model.GenericModel;
import tech.corefinance.product.entity.RateSource;
import tech.corefinance.product.enums.RateType;

@Entity
@Table(name="rate")
@EntityListeners(value={EntityBasicUserAuditorListener.class, EntityZonedDateTimeAuditListener.class, EntityDeleteListener.class})
public class Rate
implements GenericModel<String>,
CreateUpdateDto<String>,
AuditableEntity<ZonedDateTime, BasicUserDto> {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private String id;
    @Column(name="valid_from")
    private ZonedDateTime validFrom;
    @Column(name="rate_value")
    private Double rateValue;
    private String note;
    @Enumerated(value=EnumType.STRING)
    private RateType type;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="rate_source_id")
    @JsonIgnore
    private RateSource rateSource;
    @CreatedDate
    @Column(name="created_date")
    private ZonedDateTime createdDate;
    @CreatedBy
    @Column(name="created_by")
    @JdbcTypeCode(value=3001)
    private BasicUserDto createdBy;
    @LastModifiedDate
    @Column(name="last_modified_date")
    private ZonedDateTime lastModifiedDate;
    @CreatedBy
    @Column(name="last_modified_by")
    @JdbcTypeCode(value=3001)
    private BasicUserDto lastModifiedBy;

    public String getId() {
        return this.id;
    }

    public ZonedDateTime getValidFrom() {
        return this.validFrom;
    }

    public Double getRateValue() {
        return this.rateValue;
    }

    public String getNote() {
        return this.note;
    }

    public RateType getType() {
        return this.type;
    }

    public RateSource getRateSource() {
        return this.rateSource;
    }

    public ZonedDateTime getCreatedDate() {
        return this.createdDate;
    }

    public BasicUserDto getCreatedBy() {
        return this.createdBy;
    }

    public ZonedDateTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public BasicUserDto getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setValidFrom(ZonedDateTime validFrom) {
        this.validFrom = validFrom;
    }

    public void setRateValue(Double rateValue) {
        this.rateValue = rateValue;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setType(RateType type) {
        this.type = type;
    }

    @JsonIgnore
    public void setRateSource(RateSource rateSource) {
        this.rateSource = rateSource;
    }

    public void setCreatedDate(ZonedDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public void setCreatedBy(BasicUserDto createdBy) {
        this.createdBy = createdBy;
    }

    public void setLastModifiedDate(ZonedDateTime lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setLastModifiedBy(BasicUserDto lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rate)) {
            return false;
        }
        Rate other = (Rate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$rateValue = this.getRateValue();
        Double other$rateValue = other.getRateValue();
        if (this$rateValue == null ? other$rateValue != null : !((Object)this$rateValue).equals(other$rateValue)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ZonedDateTime this$validFrom = this.getValidFrom();
        ZonedDateTime other$validFrom = other.getValidFrom();
        if (this$validFrom == null ? other$validFrom != null : !((Object)this$validFrom).equals(other$validFrom)) {
            return false;
        }
        String this$note = this.getNote();
        String other$note = other.getNote();
        if (this$note == null ? other$note != null : !this$note.equals(other$note)) {
            return false;
        }
        RateType this$type = this.getType();
        RateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        RateSource this$rateSource = this.getRateSource();
        RateSource other$rateSource = other.getRateSource();
        if (this$rateSource == null ? other$rateSource != null : !((Object)this$rateSource).equals(other$rateSource)) {
            return false;
        }
        ZonedDateTime this$createdDate = this.getCreatedDate();
        ZonedDateTime other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        BasicUserDto this$createdBy = this.getCreatedBy();
        BasicUserDto other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        ZonedDateTime this$lastModifiedDate = this.getLastModifiedDate();
        ZonedDateTime other$lastModifiedDate = other.getLastModifiedDate();
        if (this$lastModifiedDate == null ? other$lastModifiedDate != null : !((Object)this$lastModifiedDate).equals(other$lastModifiedDate)) {
            return false;
        }
        BasicUserDto this$lastModifiedBy = this.getLastModifiedBy();
        BasicUserDto other$lastModifiedBy = other.getLastModifiedBy();
        return !(this$lastModifiedBy == null ? other$lastModifiedBy != null : !this$lastModifiedBy.equals(other$lastModifiedBy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Rate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $rateValue = this.getRateValue();
        result = result * 59 + ($rateValue == null ? 43 : ((Object)$rateValue).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ZonedDateTime $validFrom = this.getValidFrom();
        result = result * 59 + ($validFrom == null ? 43 : ((Object)$validFrom).hashCode());
        String $note = this.getNote();
        result = result * 59 + ($note == null ? 43 : $note.hashCode());
        RateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        RateSource $rateSource = this.getRateSource();
        result = result * 59 + ($rateSource == null ? 43 : ((Object)$rateSource).hashCode());
        ZonedDateTime $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        BasicUserDto $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        ZonedDateTime $lastModifiedDate = this.getLastModifiedDate();
        result = result * 59 + ($lastModifiedDate == null ? 43 : ((Object)$lastModifiedDate).hashCode());
        BasicUserDto $lastModifiedBy = this.getLastModifiedBy();
        result = result * 59 + ($lastModifiedBy == null ? 43 : $lastModifiedBy.hashCode());
        return result;
    }

    public String toString() {
        return "Rate(id=" + this.getId() + ", validFrom=" + String.valueOf(this.getValidFrom()) + ", rateValue=" + this.getRateValue() + ", note=" + this.getNote() + ", type=" + String.valueOf((Object)this.getType()) + ", rateSource=" + String.valueOf(this.getRateSource()) + ", createdDate=" + String.valueOf(this.getCreatedDate()) + ", createdBy=" + String.valueOf(this.getCreatedBy()) + ", lastModifiedDate=" + String.valueOf(this.getLastModifiedDate()) + ", lastModifiedBy=" + String.valueOf(this.getLastModifiedBy()) + ")";
    }
}

