/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import tech.corefinance.common.annotation.ControllerManagedResource;
import tech.corefinance.common.annotation.PermissionAction;
import tech.corefinance.common.context.ApplicationContextHolder;
import tech.corefinance.common.converter.ExportTypeConverter;
import tech.corefinance.common.dto.SimpleVersion;
import tech.corefinance.common.dto.SimpleVersionComparator;
import tech.corefinance.common.ex.ReflectiveIncorrectFieldException;
import tech.corefinance.common.model.GenericModel;
import tech.corefinance.common.service.CommonService;
import tech.corefinance.common.service.ProxyUnbox;

@Component
public class CoreFinanceUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoreFinanceUtil.class);
    public static final String PARSING_JSON_FAILURE = "Parsing json failure";
    private static final String PARSING_JSON_FAILURE_LOG = "Parsing json failure! object: {}, error: {}";
    private static final List<Class<?>> LIST_IGNORE_LOGGING = List.of(ServletRequest.class, ServletResponse.class, HttpSession.class, Servlet.class, MultipartFile.class, byte[].class, File.class, InputStream.class, Class.class, Method.class, Field.class);
    @Autowired
    private ResourcePatternResolver resourcePatternResolver;
    @Autowired
    private SimpleVersionComparator simpleVersionComparator;
    @Autowired
    private List<ProxyUnbox> proxyUnboxes;

    public Object checkAndConvertExportData(Object data) {
        if (data == null) {
            return null;
        }
        ApplicationContextHolder contextHolder = ApplicationContextHolder.getInstance();
        Map beans = contextHolder.getApplicationContext().getBeansOfType(ExportTypeConverter.class);
        for (Map.Entry entry : beans.entrySet()) {
            ExportTypeConverter converter = (ExportTypeConverter)entry.getValue();
            if (!converter.isSupport(data.getClass())) continue;
            data = converter.convert(data);
            break;
        }
        return data;
    }

    public String buildMethodInputJsonLog(ProceedingJoinPoint joinPoint, String[] parametersNames, ObjectMapper objectMapper) {
        LinkedHashMap<String, Object> logs = new LinkedHashMap<String, Object>();
        Object[] args = joinPoint.getArgs();
        if (parametersNames != null) {
            for (int i = 0; i < parametersNames.length; ++i) {
                String name = parametersNames[i];
                Object arg = args[i];
                boolean shouldIgnore = LIST_IGNORE_LOGGING.stream().anyMatch(clzz -> arg != null && clzz.isAssignableFrom(arg.getClass()));
                if (!shouldIgnore && arg != null) {
                    shouldIgnore = arg.getClass().getSimpleName().contains("$");
                }
                if (!shouldIgnore) {
                    logs.put(name, this.writeValueToJson(objectMapper, arg));
                    continue;
                }
                logs.put(name, arg == null ? "null" : "<" + arg.getClass().getName() + "/>");
            }
        }
        return this.writeValueToJson(objectMapper, logs);
    }

    public String writeValueToJson(ObjectMapper objectMapper, Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException | StackOverflowError e) {
            log.info(PARSING_JSON_FAILURE_LOG, object, (Object)e);
            return PARSING_JSON_FAILURE;
        }
    }

    public List<Resource> getResources(String regex, String nameSeparator, String versionSeparator) throws IOException {
        Predicate<Resource> fileNameFilter = r -> {
            String fileName = r.getFilename();
            if (fileName.contains(String.valueOf(nameSeparator))) {
                try {
                    this.convertVersion(fileName, nameSeparator, versionSeparator);
                    return true;
                }
                catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException e) {
                    log.error("Error", (Throwable)e);
                }
            }
            log.debug("Ignore [{}] because file does not meet defined rule!", (Object)fileName);
            return false;
        };
        Comparator fileNameComparator = (r1, r2) -> {
            SimpleVersion version2;
            SimpleVersion version1 = this.convertVersion(r1.getFilename(), nameSeparator, versionSeparator);
            int result = this.simpleVersionComparator.compare(version1, version2 = this.convertVersion(r2.getFilename(), nameSeparator, versionSeparator));
            if (result == 0) {
                result = r1.getFilename().compareTo(r2.getFilename());
            }
            return result;
        };
        return List.of(this.resourcePatternResolver.getResources(regex)).stream().filter(fileNameFilter).sorted(fileNameComparator).collect(Collectors.toList());
    }

    public SimpleVersion convertVersion(String fileName, String nameSeparator, String versionSeparator) {
        String versionPart;
        String string = versionPart = fileName != null ? fileName : "0.1";
        if (versionPart.contains(String.valueOf(nameSeparator))) {
            versionPart = versionPart.substring(0, versionPart.indexOf(nameSeparator));
        }
        short major = Short.parseShort(versionPart.substring(0, versionPart.indexOf(versionSeparator)));
        short minor = Short.parseShort(versionPart.substring(versionPart.indexOf(versionSeparator) + 1));
        return new SimpleVersion(major, minor);
    }

    public String resolveResourceAction(PermissionAction perActAnn, RequestMappingInfo requestMappingInfo) {
        String resourceType;
        String string = resourceType = perActAnn != null ? perActAnn.action() : null;
        if (!StringUtils.hasText((String)resourceType)) {
            Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
            resourceType = requestMethods.contains(RequestMethod.DELETE) ? "delete" : (requestMethods.contains(RequestMethod.GET) ? "view" : (requestMethods.contains(RequestMethod.POST) ? "add" : (requestMethods.contains(RequestMethod.PUT) || requestMethods.contains(RequestMethod.PATCH) ? "update" : "list")));
        }
        return resourceType;
    }

    public String resolveResourceType(PermissionAction perActAnn, ControllerManagedResource managedResource) {
        String resourceType;
        String string = resourceType = perActAnn != null ? perActAnn.resourceType() : null;
        if (!StringUtils.hasText((String)resourceType)) {
            if (managedResource == null) {
                log.error("Must define resource type at PermissionAction in method level or ControllerManagedResource in controller level.");
                throw new ReflectiveIncorrectFieldException("no_permission_defined");
            }
            resourceType = managedResource.value();
        }
        return resourceType;
    }

    public Object getDeepAttributeValue(Object object, String deepAttributePath) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(object);
        String[] attributeNames = deepAttributePath.split("\\.");
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            object = beanWrapper.getPropertyValue(attributeName);
            if (object == null) {
                return null;
            }
            if (i >= attributeNames.length) continue;
            beanWrapper = new BeanWrapperImpl(object);
        }
        return object;
    }

    public Class<?> findEntityTypeFromCommonService(Class<?> serviceClass) {
        log.debug("Finding entity type for service [{}]", (Object)serviceClass.getName());
        Type superClass = serviceClass.getGenericSuperclass();
        log.debug("Supper class [{}]", (Object)superClass);
        if (superClass instanceof ParameterizedType) {
            return this.extractGenericEntityType((ParameterizedType)superClass);
        }
        Object[] interfaces = serviceClass.getGenericInterfaces();
        log.debug("Continue with support interfaces {}", (Object)Arrays.toString(interfaces));
        for (Object type : interfaces) {
            if (type instanceof ParameterizedType) {
                log.debug("Type [{}] is ParameterizedType!", type);
                if (CommonService.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) {
                    log.debug("Extracting entity type...");
                    return this.extractGenericEntityType((ParameterizedType)type);
                }
                log.debug("Ignored [{}] because it's not CommonService!", type);
                continue;
            }
            if (type instanceof Class) {
                log.debug("Type [{}] is Class. Continue with findEntityTypeFromCommonService...", type);
                Class<?> tmp = this.findEntityTypeFromCommonService((Class)type);
                if (tmp == null) continue;
                return tmp;
            }
            log.debug("Ignored unknown type [{}]!", type);
        }
        return null;
    }

    private Class<?> extractGenericEntityType(ParameterizedType type) {
        Object[] argumentTypes = type.getActualTypeArguments();
        log.debug("Actual argument type {}", (Object)Arrays.toString(argumentTypes));
        for (Object t : argumentTypes) {
            if (!(t instanceof Class) || !GenericModel.class.isAssignableFrom((Class)t)) continue;
            return (Class)t;
        }
        return null;
    }

    public boolean isMatchedInstanceType(Object target, List<String> excludeClasses) {
        boolean result = false;
        log.debug("Checking if [{}] is included in list {}", target, excludeClasses);
        for (String className : excludeClasses) {
            try {
                Class<?> clzz = Class.forName(className);
                Class<?> targetClass = target.getClass();
                if (clzz.isAssignableFrom(targetClass)) {
                    log.debug("[{}] can assign from [{}]", clzz, targetClass);
                    return true;
                }
                log.debug("[{}] can not assign from [{}]", clzz, targetClass);
            }
            catch (ClassNotFoundException e) {
                log.error("Invalid configuration for class name [{}]", (Object)className, (Object)e);
            }
        }
        return result;
    }

    public Object unProxy(Object proxyObject) {
        for (ProxyUnbox unbox : this.proxyUnboxes) {
            if (!unbox.canUnbox(proxyObject)) continue;
            return unbox.unProxy(proxyObject);
        }
        return null;
    }

    public Set<Pair<String, String>> buildUrlPair(Set<String> urlPatterns) {
        HashSet<Pair<String, String>> urlPairs = new HashSet<Pair<String, String>>();
        urlPatterns.forEach(pattern -> urlPairs.add(Pair.of((Object)pattern, (Object)this.patternToUrl((String)pattern))));
        return urlPairs;
    }

    private String patternToUrl(String pattern) {
        Object url = pattern;
        int lastOpenCurlyBracketIndex = pattern.lastIndexOf("{");
        int firstCloseCurlyBracketIndex = pattern.indexOf("}");
        while (lastOpenCurlyBracketIndex >= 0 && lastOpenCurlyBracketIndex < firstCloseCurlyBracketIndex) {
            url = ((String)url).substring(0, lastOpenCurlyBracketIndex) + "*" + ((String)url).substring(firstCloseCurlyBracketIndex + 1);
            lastOpenCurlyBracketIndex = ((String)url).lastIndexOf("{");
            firstCloseCurlyBracketIndex = ((String)url).indexOf("}");
        }
        return url;
    }

    public AccessibleObject findAnnotatedField(Object obj, Class<?> objClass, Class<? extends Annotation> annotationClass) throws NoSuchFieldException {
        return this.findAnnotatedFieldOrName(obj, objClass, annotationClass, null);
    }

    public AccessibleObject findAnnotatedFieldOrName(Object obj, Class<?> objClass, Class<? extends Annotation> annotationClass, String fieldName) throws NoSuchFieldException {
        Field[] fields;
        Method[] methods;
        for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(objClass)) {
            Annotation createdByAnn = method.getAnnotation(annotationClass);
            if (createdByAnn == null) continue;
            return method;
        }
        for (Field field : fields = objClass.getDeclaredFields()) {
            CreatedBy createdByAnn = field.getAnnotation(CreatedBy.class);
            if (createdByAnn == null) continue;
            return field;
        }
        return this.accessField(obj, objClass, fieldName);
    }

    public Method findGetterBySetter(Object obj, Class<?> objClass, Method setter) throws NoSuchMethodException {
        String setterName = setter.getName();
        if (setterName.startsWith("set")) {
            String getterName = setterName.replace("set", "get");
            return objClass.getDeclaredMethod(getterName, new Class[0]);
        }
        return null;
    }

    public void triggerSetFieldValue(AccessibleObject accessibleObject, Object obj, Class<?> objClass, Object value) throws ReflectiveOperationException {
        if (accessibleObject instanceof Field) {
            Field f = (Field)accessibleObject;
            f.set(obj, value);
        } else if (accessibleObject instanceof Method) {
            Method m = (Method)accessibleObject;
            m.invoke(obj, value);
        } else {
            throw new NoSuchFieldException();
        }
    }

    public AccessibleObject accessField(Object obj, Class<?> objClass, String fieldName) throws NoSuchFieldException {
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(objClass);
        if (StringUtils.hasText((String)fieldName)) {
            String setMethodName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            for (Method method : methods) {
                if (!method.getName().equalsIgnoreCase(setMethodName)) continue;
                return method;
            }
            return objClass.getField(fieldName);
        }
        return null;
    }

    public Object triggerGetFieldValue(AccessibleObject accessibleObject, Object obj, Class<?> objClass) throws ReflectiveOperationException {
        if (accessibleObject instanceof Field) {
            Field f = (Field)accessibleObject;
            return f.get(obj);
        }
        if (accessibleObject instanceof Method) {
            Method m = (Method)accessibleObject;
            return m.invoke(obj, new Object[0]);
        }
        throw new NoSuchFieldException();
    }
}

