/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;
import tech.corefinance.common.dto.JwtTokenDto;
import tech.corefinance.common.service.JwtTokenParser;

@ConditionalOnProperty(prefix="tech.corefinance.security.jwt.enabled", name={"common-parser"}, matchIfMissing=true, havingValue="true")
@Component
public class JwtTokenParserImpl
implements JwtTokenParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtTokenParserImpl.class);
    private ObjectMapper objectMapper;

    public JwtTokenParserImpl(@Autowired ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public JwtTokenDto parse(String json) throws JsonProcessingException {
        TypeReference<Map<String, Serializable>> mapTypeReference = new TypeReference<Map<String, Serializable>>(this){};
        Map map = (Map)this.objectMapper.readValue(json, (TypeReference)mapTypeReference);
        Class<JwtTokenDto> resultClass = JwtTokenDto.class;
        JwtTokenDto result = (JwtTokenDto)this.objectMapper.readValue(json, resultClass);
        for (Map.Entry entry : map.entrySet()) {
            String fieldName = (String)entry.getKey();
            if (ReflectionUtils.findField(resultClass, (String)fieldName) != null) continue;
            result.getAdditionalInfo().put(fieldName, (Serializable)entry.getValue());
        }
        return result;
    }
}

