/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.Ordered;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="tech.corefinance.common.enabled", name={"auto-response-encoding"})
public class EncodingHeaderFilter
implements Filter,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncodingHeaderFilter.class);
    @Value(value="${tech.corefinance.common.default-response-charset:utf-8}")
    private String charset;
    @Value(value="${tech.corefinance.common.filter-ordered.encoding-response-order:0}")
    private int order;
    private static final List<String> TEXT_CONTENT_TYPES = List.of("text/html", "text/plain", "text/xml", "application/json", "application/xml", "application/xhtml+xml", "application/vnd.mozilla.xul+xml", "application/vnd.oasis.opendocument.text", "application/ld+json");

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        try {
            String contentType = response.getContentType();
            if (contentType == null || !contentType.contains("charset=") && this.isTextContentType(contentType)) {
                log.debug("Setting encoding charset [{}] to response...", (Object)this.charset);
                response.setCharacterEncoding(this.charset);
            }
        }
        catch (Throwable t) {
            log.error("Set encoding error!", t);
        }
    }

    private boolean isTextContentType(String contentType) {
        MediaType mediaType = MediaType.parseMediaType((String)contentType);
        return mediaType.getType().equals("text") || TEXT_CONTENT_TYPES.contains(contentType);
    }

    public int getOrder() {
        return this.order;
    }
}

