/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.converter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.format.Formatter;
import org.springframework.stereotype.Component;
import tech.corefinance.common.converter.CommonCustomConverter;

@Component
public class OrderListConverter
implements CommonCustomConverter<String, List<Sort.Order>>,
Formatter<List<Sort.Order>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrderListConverter.class);
    private ObjectMapper objectMapper = new ObjectMapper();

    public List<Sort.Order> convert(String value) {
        LinkedList<Sort.Order> orders = new LinkedList<Sort.Order>();
        List orderMap = (List)this.objectMapper.readValue(value, (TypeReference)new TypeReference<List<LinkedHashMap<String, String>>>(this){});
        log.debug("Order map {}", (Object)orderMap);
        orderMap.forEach(map -> {
            Sort.Order order = null;
            String property = (String)map.get("property");
            order = "ASC".equalsIgnoreCase((String)map.get("direction")) ? Sort.Order.asc((String)property) : Sort.Order.desc((String)property);
            orders.add(order);
        });
        return orders;
    }

    public String print(List<Sort.Order> object, Locale locale) {
        log.info("Calling custom formatter for List<Order> {}! Locale ignored!", object);
        return this.objectMapper.writeValueAsString(object);
    }

    public List<Sort.Order> parse(String text, Locale locale) throws ParseException {
        log.info("Calling custom formatter to parse {] to List<Order>! Locale ignored!", (Object)text);
        return this.convert(text);
    }
}

