/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.converter;

import jakarta.annotation.PostConstruct;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import tech.corefinance.common.converter.ExportTypeConverter;
import tech.corefinance.common.ex.ServiceProcessingException;

@Component
public class DateExportConverter
implements ExportTypeConverter<Object, String> {
    @Value(value="${export.format.date:dd/MM/yyyy}")
    private String exportDateFormat;
    @Value(value="${export.format.datetime:dd/MM/yyyy HH:mm:ss}")
    private String exportDateTimeFormat;
    private SimpleDateFormat dateFormat;
    private DateTimeFormatter dateFormatter;
    private DateTimeFormatter dateTimeFormatter;
    private DateTimeFormatter instantFormatter;

    @PostConstruct
    public void postConstruct() {
        this.dateFormat = new SimpleDateFormat(this.exportDateFormat);
        this.dateFormatter = DateTimeFormatter.ofPattern(this.exportDateFormat);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.exportDateTimeFormat);
        this.instantFormatter = DateTimeFormatter.ofPattern(this.exportDateTimeFormat).withZone(ZoneId.systemDefault());
    }

    @Override
    public String convert(Object data) {
        if (data != null) {
            Class<?> clzz = data.getClass();
            if (Date.class.isAssignableFrom(clzz)) {
                return this.dateFormat.format((Date)data);
            }
            if (ChronoLocalDate.class.isAssignableFrom(clzz)) {
                return this.dateFormatter.format((ChronoLocalDate)data);
            }
            if (ChronoLocalDateTime.class.isAssignableFrom(clzz)) {
                return this.dateTimeFormatter.format((ChronoLocalDateTime)data);
            }
            if (ChronoZonedDateTime.class.isAssignableFrom(clzz)) {
                return this.dateTimeFormatter.format((ChronoZonedDateTime)data);
            }
            if (Instant.class.isAssignableFrom(clzz)) {
                return this.instantFormatter.format((Instant)data);
            }
            throw new ServiceProcessingException("Cannot convert type " + clzz.getName() + " to " + String.class.getName());
        }
        return "";
    }

    @Override
    public boolean isSupport(Class<?> dataType) {
        Class[] supportedType;
        for (Class clzz : supportedType = new Class[]{Date.class, ChronoLocalDate.class, ChronoLocalDateTime.class, ChronoZonedDateTime.class, Instant.class}) {
            if (!clzz.isAssignableFrom(dataType)) continue;
            return true;
        }
        return false;
    }
}

