/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import tech.corefinance.common.dto.GeneralApiResponse;
import tech.corefinance.common.ex.ResourceNotFound;
import tech.corefinance.common.ex.ServiceProcessingException;

@ControllerAdvice
@ResponseBody
@RequestMapping(produces={"application/json"})
@ResponseStatus(code=HttpStatus.INTERNAL_SERVER_ERROR)
@ConditionalOnProperty(prefix="tech.corefinance.common", name={"generic-exception-handling"}, havingValue="true", matchIfMissing=true)
public class ExceptionController
extends ResponseEntityExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionController.class);

    @ExceptionHandler(value={ServiceProcessingException.class})
    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    public Object handleProcessingException(HttpServletRequest request, Exception e) {
        return this.handleGeneralException(request, e, 1);
    }

    @ExceptionHandler(value={ParserConfigurationException.class, JsonProcessingException.class})
    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    public String handleJsonException(Exception e) {
        log.error("Parse exception", (Throwable)e);
        return "{\"status\": 1, \"statusCode\": \"invalid_input_or_response\", \"result\": [\"invalid_input_or_response\"]}";
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public GeneralApiResponse<String[]> accessDenied(AccessDeniedException e) {
        log.debug(e.getMessage(), (Throwable)e);
        return new GeneralApiResponse<String[]>("access_denied", 1, new String[]{e.getMessage()});
    }

    @ExceptionHandler(value={IllegalArgumentException.class, ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public GeneralApiResponse<String[]> badRequest(Exception e) {
        log.debug(e.getMessage(), (Throwable)e);
        if (e instanceof IllegalArgumentException) {
            return new GeneralApiResponse<String[]>("bad_request", 1, new String[]{e.getMessage()});
        }
        if (e instanceof ConstraintViolationException) {
            ConstraintViolationException cve = (ConstraintViolationException)e;
            Set violatedSet = cve.getConstraintViolations();
            LinkedList<String> msgs = new LinkedList<String>();
            for (ConstraintViolation violatedItem : violatedSet) {
                String m = violatedItem.getMessage();
                msgs.add(m);
            }
            return new GeneralApiResponse<String[]>("bad_request", 1, msgs.toArray(new String[0]));
        }
        return new GeneralApiResponse<Object>("system_error", 1, null);
    }

    @ExceptionHandler(value={Throwable.class})
    public GeneralApiResponse<String[]> internalServerError(Throwable e) {
        log.error("System Exception", e);
        return new GeneralApiResponse<String[]>("system_error", 1, new String[]{e.getMessage()});
    }

    @ExceptionHandler(value={ResourceNotFound.class, NoSuchElementException.class})
    @ResponseStatus(code=HttpStatus.NOT_FOUND)
    public Object handleResourceNotFound(HttpServletRequest request, Exception e) {
        return this.handleGeneralException(request, e, 404);
    }

    private Object handleGeneralException(HttpServletRequest request, Exception e, int status) {
        String message = e.getMessage();
        Throwable cause = e.getCause();
        log.error("Return error for user: [{}]", (Object)message);
        if (cause != null) {
            log.error("Exception", cause);
        } else {
            cause = e;
        }
        if (message != null && !message.trim().isEmpty()) {
            if (!message.contains("\"statusCode\"")) {
                return new GeneralApiResponse<String[]>(message, status, new String[]{message});
            }
            return message;
        }
        return this.internalServerError(cause);
    }

    protected ResponseEntity<Object> createResponseEntity(@Nullable Object body, HttpHeaders headers, HttpStatusCode statusCode, WebRequest request) {
        if (body instanceof String) {
            String s = (String)body;
            body = new String[]{s};
        }
        GeneralApiResponse<Object> errorResponse = new GeneralApiResponse<Object>(body);
        if (body instanceof ProblemDetail) {
            ProblemDetail problemDetail = (ProblemDetail)body;
            errorResponse.setStatus(problemDetail.getStatus());
        } else {
            errorResponse.setStatus(GeneralApiResponse.STATUS_UNKNOWN_ERROR);
        }
        return new ResponseEntity(errorResponse, (MultiValueMap)headers, statusCode);
    }
}

