/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.context;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.SimpleTimeZoneAwareLocaleContext;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.AbstractLocaleContextResolver;

public class StatelessLocaleResolver
extends AbstractLocaleContextResolver
implements LocaleResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatelessLocaleResolver.class);

    public LocaleContext resolveLocaleContext(HttpServletRequest request) {
        String localeKey = request.getHeader("x-lang_key");
        if (localeKey == null) {
            localeKey = "en";
            log.debug("No local in header, used to default locale [{}]", (Object)localeKey);
        } else {
            log.debug("Resolved local in header [{}]", (Object)localeKey);
        }
        Locale locale = Locale.of(localeKey);
        return new SimpleTimeZoneAwareLocaleContext(locale, this.getDefaultTimeZone());
    }

    public void setLocaleContext(@NonNull HttpServletRequest request, HttpServletResponse response, LocaleContext localeContext) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
    }
}

