/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.context;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.corefinance.common.dto.JwtTokenDto;

public class JwtContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtContext.class);
    private ThreadLocal<JwtTokenDto> tokenThreadLocal = new ThreadLocal();
    private ThreadLocal<String> tokenStringThreadLocal = new ThreadLocal();
    private static final JwtContext INSTANCE = new JwtContext();

    private JwtContext() {
        log.debug("Created PermissionContext [{}]", (Object)this);
    }

    public static JwtContext getInstance() {
        return INSTANCE;
    }

    public void setJwt(JwtTokenDto jwt) {
        this.tokenThreadLocal.set(jwt);
    }

    public void removeJwt() {
        this.tokenThreadLocal.remove();
    }

    public JwtTokenDto getJwt() {
        return this.tokenThreadLocal.get();
    }

    public void setTokenString(String tokenString) {
        this.tokenStringThreadLocal.set(tokenString);
    }

    public void removeTokenString() {
        this.tokenStringThreadLocal.remove();
    }

    public String getTokenString() {
        return this.tokenStringThreadLocal.get();
    }
}

