/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.config;

import jakarta.servlet.Filter;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import tech.corefinance.common.config.ServiceSecurityConfig;
import tech.corefinance.common.config.UrlBasedCorsConfiguration;
import tech.corefinance.common.filter.SessionAuthenticationFilter;
import tech.corefinance.common.model.AnonymousUrlAccess;
import tech.corefinance.common.repository.AnonymousUrlAccessRepository;

@Configuration
public class WebSecurityConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSecurityConfig.class);
    @Autowired
    private ServiceSecurityConfig serviceSecurityConfig;
    @Autowired
    private AnonymousUrlAccessRepository anonymousUrlAccessRepository;
    @Autowired(required=false)
    private UrlBasedCorsConfiguration urlBasedCorsConfiguration;

    @Bean
    @ConditionalOnProperty(prefix="tech.corefinance.security", name={"public-key"})
    public SecurityFilterChain filterChain(HttpSecurity http, SessionAuthenticationFilter sessionAuthenticationFilter) throws Exception {
        List anonymousList = this.anonymousUrlAccessRepository.findAll();
        return (SecurityFilterChain)http.csrf(csrf -> csrf.disable()).cors(c -> c.configurationSource(this.corsConfigurationSource())).authorizeHttpRequests(auth -> this.serviceSecurityConfig.getNoAuthenUrls().stream().forEach(url -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{url})).permitAll())).authorizeHttpRequests(auth -> anonymousList.stream().forEach(p -> this.registerPermitAllAccess((AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry)auth, (AnonymousUrlAccess)p))).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).authenticated()).addFilterBefore((Filter)sessionAuthenticationFilter, AnonymousAuthenticationFilter.class).sessionManagement(sess -> sess.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).build();
    }

    private void registerPermitAllAccess(AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry auth, AnonymousUrlAccess anonymousUrlAccess) {
        HttpMethod httpMethod = null;
        RequestMethod requestMethod = anonymousUrlAccess.getRequestMethod();
        if (requestMethod != null) {
            httpMethod = requestMethod.asHttpMethod();
        }
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(httpMethod, new String[]{anonymousUrlAccess.getUrl()})).permitAll();
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        if (this.urlBasedCorsConfiguration != null) {
            this.urlBasedCorsConfiguration.getCorsConfigurations().forEach(t -> {
                log.debug("CORS Configuration for [{}] is [AllowedOrigins={},AllowedHeaders={}, AllowedMethods={}]", new Object[]{t.getUrlPattern(), t.getAllowedOrigins(), t.getAllowedHeaders(), t.getAllowedMethods()});
                source.registerCorsConfiguration(t.getUrlPattern(), (CorsConfiguration)t);
            });
        }
        return source;
    }
}

