/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.audit;

import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.LastModifiedBy;
import tech.corefinance.common.annotation.CustomAuditor;
import tech.corefinance.common.audit.BasicUserAuditorAware;
import tech.corefinance.common.context.ApplicationContextHolder;
import tech.corefinance.common.dto.BasicUserDto;
import tech.corefinance.common.enums.CustomAuditorField;
import tech.corefinance.common.ex.ServiceProcessingException;
import tech.corefinance.common.model.AuditableEntity;
import tech.corefinance.common.util.CoreFinanceUtil;

@Configurable
@ConditionalOnProperty(name={"tech.corefinance.audit.enabled.basic-user"}, havingValue="true", matchIfMissing=true)
public class EntityBasicUserAuditorListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityBasicUserAuditorListener.class);

    @PrePersist
    private void beforeInsert(Object obj) {
        log.debug("Before inserting {}", obj);
        ApplicationContext context = ApplicationContextHolder.getInstance().getApplicationContext();
        BasicUserAuditorAware userAuditorAware = (BasicUserAuditorAware)context.getBean(BasicUserAuditorAware.class);
        CoreFinanceUtil util = (CoreFinanceUtil)context.getBean(CoreFinanceUtil.class);
        Class<?> objClass = obj.getClass();
        CustomAuditor customAuditor = objClass.getAnnotation(CustomAuditor.class);
        if (obj instanceof AuditableEntity) {
            AuditableEntity en = (AuditableEntity)obj;
            this.setAuditorToAuditableEntity(en, userAuditorAware);
        } else if (customAuditor != null) {
            this.setAuditorToAuditableEntity(userAuditorAware, customAuditor, obj, objClass, util);
        } else {
            log.debug("{} is not auditable.", obj);
        }
    }

    @PreUpdate
    private void beforeUpdate(Object obj) {
        log.debug("Before updating {}", obj);
        ApplicationContext context = ApplicationContextHolder.getInstance().getApplicationContext();
        BasicUserAuditorAware userAuditorAware = (BasicUserAuditorAware)context.getBean(BasicUserAuditorAware.class);
        CoreFinanceUtil util = (CoreFinanceUtil)context.getBean(CoreFinanceUtil.class);
        Class<?> objClass = obj.getClass();
        CustomAuditor customAuditor = objClass.getAnnotation(CustomAuditor.class);
        if (obj instanceof AuditableEntity) {
            AuditableEntity en = (AuditableEntity)obj;
            this.updateAuditorToAuditableEntity(en, userAuditorAware);
        } else if (customAuditor != null) {
            this.updateAuditorToAuditableEntity(userAuditorAware, customAuditor, obj, objClass, util);
        } else {
            log.debug("{} is not auditable.", obj);
        }
    }

    private void setAuditorToAuditableEntity(AuditableEntity<Serializable> en, BasicUserAuditorAware userAuditorAware) {
        Optional<BasicUserDto> auditor = userAuditorAware.getCurrentAuditor();
        if (en.getCreatedBy() == null) {
            log.debug("Setting {} to createdBy attribute.", auditor);
            auditor.ifPresent(en::setCreatedBy);
        } else {
            log.debug("createdBy attribute already set manually!");
        }
        log.debug("Setting {} to lastModifiedBy attribute.", auditor);
        auditor.ifPresent(en::setLastModifiedBy);
    }

    private void updateAuditorToAuditableEntity(AuditableEntity<Serializable> en, BasicUserAuditorAware userAuditorAware) {
        Optional<BasicUserDto> auditor = userAuditorAware.getCurrentAuditor();
        log.debug("Setting {} to lastModifiedBy attribute.", auditor);
        auditor.ifPresent(en::setLastModifiedBy);
    }

    private void setAuditorToAuditableEntity(BasicUserAuditorAware userAuditorAware, CustomAuditor customAuditor, Object obj, Class<?> objClass, CoreFinanceUtil util) {
        Optional<BasicUserDto> auditorOptional = userAuditorAware.getCurrentAuditor();
        if (auditorOptional.isPresent()) {
            BasicUserDto auditor = auditorOptional.get();
            try {
                String string;
                String fieldName;
                AccessibleObject createdByField = util.findAnnotatedFieldOrName(obj, objClass, CreatedBy.class, "createdBy");
                createdByField.setAccessible(true);
                Object createdBy = null;
                if (createdByField instanceof Field) {
                    Field f = (Field)createdByField;
                    createdBy = f.get(obj);
                } else {
                    createdBy = util.findGetterBySetter(obj, objClass, (Method)createdByField).invoke(obj, new Object[0]);
                }
                if (createdByField instanceof Field) {
                    Field f = (Field)createdByField;
                    v0 = f.getName();
                } else {
                    v0 = fieldName = ((Executable)createdByField).getName();
                }
                if (createdBy == null) {
                    Object createdVal = this.retrieveAuditor(customAuditor.createdByType(), auditor);
                    log.debug("Setting [{}] to [{}] attribute.", (Object)auditor, (Object)fieldName);
                    util.triggerSetFieldValue(createdByField, obj, objClass, createdVal);
                } else {
                    log.debug("[{}] attribute already set manually!", (Object)fieldName);
                }
                Object lastModifiedByVal = this.retrieveAuditor(customAuditor.lastModifiedByType(), auditor);
                AccessibleObject lastModifiedByField = util.findAnnotatedFieldOrName(obj, objClass, LastModifiedBy.class, "lastModifiedBy");
                lastModifiedByField.setAccessible(true);
                if (lastModifiedByField instanceof Field) {
                    Field f = (Field)lastModifiedByField;
                    string = f.getName();
                } else {
                    string = ((Executable)lastModifiedByField).getName();
                }
                fieldName = string;
                log.debug("Setting {} to {} attribute.", lastModifiedByVal, (Object)fieldName);
                util.triggerSetFieldValue(lastModifiedByField, obj, objClass, lastModifiedByVal);
            }
            catch (ReflectiveOperationException ex) {
                throw new ServiceProcessingException(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void updateAuditorToAuditableEntity(BasicUserAuditorAware userAuditorAware, CustomAuditor customAuditor, Object obj, Class<?> objClass, CoreFinanceUtil util) {
        Optional<BasicUserDto> auditorOptional = userAuditorAware.getCurrentAuditor();
        if (auditorOptional.isPresent()) {
            BasicUserDto auditor = auditorOptional.get();
            try {
                String string;
                Object lastModifiedByVal = this.retrieveAuditor(customAuditor.lastModifiedByType(), auditor);
                AccessibleObject lastModifiedByField = util.findAnnotatedFieldOrName(obj, objClass, LastModifiedBy.class, "lastModifiedBy");
                lastModifiedByField.setAccessible(true);
                if (lastModifiedByField instanceof Field) {
                    Field f = (Field)lastModifiedByField;
                    string = f.getName();
                } else {
                    string = ((Executable)lastModifiedByField).getName();
                }
                String fieldName = string;
                log.debug("Setting {} to {} attribute.", lastModifiedByVal, (Object)fieldName);
                util.triggerSetFieldValue(lastModifiedByField, obj, objClass, lastModifiedByVal);
            }
            catch (ReflectiveOperationException ex) {
                throw new ServiceProcessingException(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private Object retrieveAuditor(CustomAuditorField field, BasicUserDto auditor) {
        return switch (field) {
            case CustomAuditorField.USER_ID -> auditor.getUserId();
            case CustomAuditorField.USER_DISPLAY_NAME -> auditor.getDisplayName();
            case CustomAuditorField.USERNAME -> auditor.getUsername();
            default -> auditor;
        };
    }
}

