/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.audit;

import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.AuditorAware;
import org.springframework.stereotype.Component;
import tech.corefinance.common.context.JwtContext;
import tech.corefinance.common.dto.BasicUserDto;
import tech.corefinance.common.service.JwtService;

@Component
@ConditionalOnProperty(name={"tech.corefinance.audit.enabled.basic-user"}, havingValue="true", matchIfMissing=true)
public class BasicUserAuditorAware
implements AuditorAware<BasicUserDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicUserAuditorAware.class);
    @Autowired
    private JwtService jwtService;

    public Optional<BasicUserDto> getCurrentAuditor() {
        BasicUserDto user = this.jwtService.retrieveUserAsAttribute(JwtContext.getInstance().getJwt());
        if (user == null) {
            log.debug("AuditorAware<BasicUserDto> retrieved null data!!");
            return Optional.empty();
        }
        log.debug("AuditorAware<BasicUserDto> got user from JwtContext.");
        return Optional.of(user);
    }
}

