/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.aop;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import tech.corefinance.common.aop.MethodDataLoging;

@Aspect
@Component
@ConditionalOnProperty(name={"tech.corefinance.log.enabled.api"}, havingValue="true", matchIfMissing=true)
public class ApiLogging
extends MethodDataLoging {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiLogging.class);
    @Autowired
    private HttpServletRequest request;

    public ApiLogging(@Value(value="${tech.corefinance.log.exclude-classes:feign.Target}") List<String> excludeClasses) {
        super(excludeClasses);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.GetMapping)")
    public Object logGetRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.doLogging(joinPoint);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.PostMapping)")
    public Object logPostRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.doLogging(joinPoint);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.PutMapping)")
    public Object logPutRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.doLogging(joinPoint);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.PatchMapping)")
    public Object verifyPatchRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.doLogging(joinPoint);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.DeleteMapping)")
    public Object verifyDeleteRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.doLogging(joinPoint);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.doLogging(joinPoint);
    }

    @Override
    protected void doAdditionalInputLog(ProceedingJoinPoint joinPoint, ObjectMapper objectMapper) {
        log.debug("== Request header <= START");
        log.debug("API: [{}] - [{}]", (Object)this.request.getMethod(), (Object)this.request.getServletPath());
        Collections.list(this.request.getHeaderNames()).forEach(h -> log.debug("Name: [{}] - Value: [{}]", h, (Object)this.request.getHeader(h)));
        log.debug("== Request header <=   END");
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

