/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.aop;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.Pair;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import tech.corefinance.common.annotation.ControllerManagedResource;
import tech.corefinance.common.annotation.PermissionAction;
import tech.corefinance.common.annotation.PermissionResource;
import tech.corefinance.common.context.JwtContext;
import tech.corefinance.common.dto.JwtTokenDto;
import tech.corefinance.common.dto.UserRoleDto;
import tech.corefinance.common.enums.AccessControl;
import tech.corefinance.common.model.Permission;
import tech.corefinance.common.repository.PermissionRepository;
import tech.corefinance.common.service.InternalApiVerify;
import tech.corefinance.common.service.ResourceOwnerVerifier;
import tech.corefinance.common.util.CoreFinanceUtil;

@Aspect
@Component
@ConditionalOnProperty(prefix="tech.corefinance.security", name={"authorize-check"}, havingValue="true", matchIfMissing=true)
public class ApiAuthorizationCheck {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiAuthorizationCheck.class);
    private static final String EXECUTION_EXCLUDED = "!@annotation(tech.corefinance.common.annotation.ManualPermissionCheck)";
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private List<RequestMappingHandlerMapping> handlerMappings;
    @Autowired
    private CoreFinanceUtil coreFinanceUtil;
    @Autowired
    private PermissionRepository permissionRepository;
    @Autowired(required=false)
    private List<ResourceOwnerVerifier> resourceOwnerVerifiers;
    @Autowired(required=false)
    private List<InternalApiVerify> internalApiVerifiers;
    @Value(value="${tech.corefinance.security.permission.default-control}")
    private AccessControl permissionDefaultControl;
    @Value(value="${tech.corefinance.security.exclude-classes-authorize-check:}")
    private List<String> excludeClasses;

    @Around(value="@annotation(org.springframework.web.bind.annotation.GetMapping) && !@annotation(tech.corefinance.common.annotation.ManualPermissionCheck)")
    public Object verifyGetRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.verifyRequest(joinPoint, RequestMethod.GET);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.PostMapping) && !@annotation(tech.corefinance.common.annotation.ManualPermissionCheck)")
    public Object verifyPostRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.verifyRequest(joinPoint, RequestMethod.POST);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.PutMapping) && !@annotation(tech.corefinance.common.annotation.ManualPermissionCheck)")
    public Object verifyPutRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.verifyRequest(joinPoint, RequestMethod.PUT);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.PatchMapping) && !@annotation(tech.corefinance.common.annotation.ManualPermissionCheck)")
    public Object verifyPatchRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.verifyRequest(joinPoint, RequestMethod.PATCH);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.DeleteMapping) && !@annotation(tech.corefinance.common.annotation.ManualPermissionCheck)")
    public Object verifyDeleteRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.verifyRequest(joinPoint, RequestMethod.DELETE);
    }

    @Around(value="@annotation(org.springframework.web.bind.annotation.RequestMapping) && !@annotation(tech.corefinance.common.annotation.ManualPermissionCheck)")
    public Object verifyGenericRequest(ProceedingJoinPoint joinPoint) throws Throwable {
        return this.verifyRequest(joinPoint, RequestMethod.valueOf((String)this.request.getMethod()));
    }

    public Object verifyRequest(ProceedingJoinPoint joinPoint, RequestMethod requestMethod) throws Throwable {
        JwtTokenDto jwtTokenDto = JwtContext.getInstance().getJwt();
        if (jwtTokenDto != null) {
            Object unProxyObj;
            Object target = joinPoint.getTarget();
            Class<?> controllerClass = target.getClass();
            String controllerClassName = controllerClass.getName();
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            log.debug("Controller class [{}]", controllerClass);
            if (Proxy.isProxyClass(controllerClass) && (unProxyObj = this.coreFinanceUtil.unProxy(target)) != null) {
                controllerClass = unProxyObj.getClass();
                log.debug("UnProxy target class [{}]", controllerClass);
                log.debug("Checking with ignored list {}", this.excludeClasses);
                if (this.coreFinanceUtil.isMatchedInstanceType(unProxyObj, this.excludeClasses)) {
                    log.debug("Excluded for [{}]", unProxyObj);
                    return joinPoint.proceed();
                }
            }
            log.debug("Verifying method [{}#{}]", (Object)controllerClassName, (Object)signature.getName());
            Map.Entry<RequestMappingInfo, HandlerMethod> handlerMethodEntry = this.resolveHandlerInfo(method);
            if (handlerMethodEntry == null) {
                log.error("This error should not happen. If it happens, please check AOP condition.");
                throw new IllegalStateException("unknown_method_handler");
            }
            String url = this.resolveUrl(handlerMethodEntry, this.request);
            log.debug("Resolved URL [{}] for request URI [{}]", (Object)url, (Object)this.request.getRequestURI());
            PermissionAction perActAnn = method.getAnnotation(PermissionAction.class);
            String action = this.coreFinanceUtil.resolveResourceAction(perActAnn, handlerMethodEntry.getKey());
            ControllerManagedResource controllerManagedResource = controllerClass.getAnnotation(ControllerManagedResource.class);
            String resourceType = this.coreFinanceUtil.resolveResourceType(perActAnn, controllerManagedResource);
            Collection<UserRoleDto> userRoles = jwtTokenDto.getUserRoles();
            boolean foundMatched = false;
            boolean isAdmin = false;
            for (UserRoleDto userRole : userRoles) {
                if (!"SystemAdmin".equalsIgnoreCase(userRole.getRoleId())) continue;
                isAdmin = true;
                break;
            }
            if (!isAdmin) {
                boolean internalCheckPass = true;
                if (this.internalApiVerifiers != null) {
                    for (InternalApiVerify verifier : this.internalApiVerifiers) {
                        if (verifier.internalPermissionCheck(controllerClass, method, this.request)) continue;
                        internalCheckPass = false;
                        break;
                    }
                }
                if (internalCheckPass) {
                    for (UserRoleDto userRole : userRoles) {
                        if (!this.verifyRole(jwtTokenDto, userRole, action, url, requestMethod, resourceType, joinPoint)) continue;
                        foundMatched = true;
                    }
                }
                if (!foundMatched && AccessControl.ALLOWED != this.permissionDefaultControl) {
                    throw new AccessDeniedException("no_permission_config");
                }
            }
        }
        return joinPoint.proceed();
    }

    private Map.Entry<RequestMappingInfo, HandlerMethod> resolveHandlerInfo(Method method) {
        for (RequestMappingHandlerMapping mapping : this.handlerMappings) {
            Map handlerMethods = mapping.getHandlerMethods();
            for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : handlerMethods.entrySet()) {
                HandlerMethod value = (HandlerMethod)entry.getValue();
                if (!method.equals(value.getMethod())) continue;
                return entry;
            }
        }
        return null;
    }

    private String resolveUrl(Map.Entry<RequestMappingInfo, HandlerMethod> handlerMethodEntry, HttpServletRequest request) {
        Set<Pair<String, String>> urls = this.coreFinanceUtil.buildUrlPair(handlerMethodEntry.getKey().getPatternValues());
        String result = null;
        for (Pair<String, String> url : urls) {
            if (RegexRequestMatcher.regexMatcher((String)((String)url.getSecond())).matches(request)) {
                result = (String)url.getSecond();
                break;
            }
            if (result != null) continue;
            result = (String)url.getSecond();
        }
        return result;
    }

    private boolean verifyRole(JwtTokenDto jwtTokenDto, UserRoleDto userRole, String action, String url, RequestMethod requestMethod, String resourceType, ProceedingJoinPoint joinPoint) {
        Sort sort = Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.ASC, "action"), new Sort.Order(Sort.Direction.ASC, "url")});
        List<Permission> permissions = this.permissionRepository.findAllByRoleIdAndResourceType(userRole.getRoleId(), resourceType, sort);
        boolean foundMatched = false;
        for (Permission permission : permissions) {
            boolean matchedRequestMethod;
            boolean matchedAction = "ANY".equalsIgnoreCase(permission.getAction()) || action.equalsIgnoreCase(permission.getAction());
            boolean matchUrl = "ANY".equalsIgnoreCase(permission.getUrl()) || url.equalsIgnoreCase(permission.getUrl());
            boolean bl = matchedRequestMethod = permission.getRequestMethod() == null || permission.getRequestMethod() == requestMethod;
            if (!matchedAction || !matchUrl || !matchedRequestMethod) continue;
            foundMatched = true;
            this.checkPermissionControl(jwtTokenDto, permission, joinPoint, userRole);
        }
        return foundMatched;
    }

    private ResourceInfoPair resolveResourceId(ProceedingJoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Annotation[][] annotations = method.getParameterAnnotations();
        log.debug("ANN [{}]", new Object[]{annotations});
        PermissionResource permissionResource = null;
        Object parameterValue = null;
        block0: for (int i = 0; i < annotations.length; ++i) {
            for (Annotation annotation : annotations[i]) {
                if (!PermissionResource.class.isAssignableFrom(annotation.annotationType())) continue;
                permissionResource = (PermissionResource)annotation;
                parameterValue = joinPoint.getArgs()[i];
                break block0;
            }
        }
        if (permissionResource == null) {
            throw new AccessDeniedException("no_resource_id_to_verify_permission");
        }
        if (!StringUtils.hasText((String)permissionResource.idPath())) {
            return new ResourceInfoPair(permissionResource.resourceType(), parameterValue);
        }
        if (parameterValue == null) {
            return new ResourceInfoPair(permissionResource.resourceType(), null);
        }
        String fieldPath = permissionResource.idPath();
        Object extractedValue = this.coreFinanceUtil.getDeepAttributeValue(parameterValue, fieldPath);
        return new ResourceInfoPair(permissionResource.resourceType(), extractedValue);
    }

    private boolean checkResourceOwnership(JwtTokenDto jwtTokenDto, String resourceType, Object resourceId, Permission permission, UserRoleDto userRole) {
        boolean result = false;
        for (ResourceOwnerVerifier verifier : this.resourceOwnerVerifiers) {
            if (!verifier.isSupportedResource(resourceType)) continue;
            result = verifier.verifyOwner(jwtTokenDto, resourceType, resourceId, permission, userRole);
            break;
        }
        return result;
    }

    private void checkPermissionControl(JwtTokenDto jwtTokenDto, Permission permission, ProceedingJoinPoint joinPoint, UserRoleDto userRole) {
        AccessControl control = permission.getControl();
        switch (control) {
            case DENIED: {
                throw new AccessDeniedException("access_denied_" + permission.getId());
            }
            case ALLOWED_SPECIFIC_RESOURCES: {
                ResourceInfoPair resourceInfo = this.resolveResourceId(joinPoint);
                boolean matched = this.checkResourceOwnership(jwtTokenDto, resourceInfo.resourceType, resourceInfo.resourceId, permission, userRole);
                if (matched) break;
                throw new AccessDeniedException("access_denied_" + permission.getId());
            }
            case DENIED_SPECIFIC_RESOURCES: {
                ResourceInfoPair resourceInfo = this.resolveResourceId(joinPoint);
                boolean matched = this.checkResourceOwnership(jwtTokenDto, resourceInfo.resourceType, resourceInfo.resourceId, permission, userRole);
                if (!matched) break;
                throw new AccessDeniedException("access_denied_" + permission.getId());
            }
        }
    }

    record ResourceInfoPair(String resourceType, Object resourceId) {
    }
}

