/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.service;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.util.ReflectionUtils;
import tech.corefinance.common.annotation.UniqueField;
import tech.corefinance.common.context.ApplicationContextHolder;
import tech.corefinance.common.ex.ReflectiveIncorrectFieldException;
import tech.corefinance.common.model.GenericModel;

public class RepositoryUniqueValidator
implements ConstraintValidator<UniqueField, GenericModel<?>> {
    private static final Logger log = LoggerFactory.getLogger(RepositoryUniqueValidator.class);
    private UniqueField uniqueField;
    private PagingAndSortingRepository<?, ?> repository;

    public void initialize(UniqueField constraintAnnotation) {
        this.uniqueField = constraintAnnotation;
    }

    public boolean isValid(GenericModel<?> value, ConstraintValidatorContext context) {
        ApplicationContext applicationContext = ApplicationContextHolder.getInstance().getApplicationContext();
        this.repository = (PagingAndSortingRepository)applicationContext.getBean(this.uniqueField.repositoryBeanName());
        try {
            Boolean result;
            Field field = ReflectionUtils.findRequiredField(value.getClass(), (String)this.uniqueField.fieldName());
            field.setAccessible(true);
            Object fieldValue = field.get(value);
            Class<?> idType = this.uniqueField.idType();
            if (Void.TYPE.equals(idType)) {
                Method method = ReflectionUtils.findRequiredMethod(this.repository.getClass(), (String)this.uniqueField.repoMethodName(), (Class[])new Class[]{this.uniqueField.fieldType()});
                result = (Boolean)method.invoke(this.repository, fieldValue) == false;
                log.info("Validated [{}] with field [{}]=[{}] and result id [{}]", new Object[]{value.getClass().getName(), this.uniqueField.fieldName(), fieldValue, result != false ? "valid" : "invalid"});
            } else {
                Object idValue = value.getId();
                Method method = ReflectionUtils.findRequiredMethod(this.repository.getClass(), (String)this.uniqueField.repoMethodName(), (Class[])new Class[]{this.uniqueField.fieldType(), idType});
                result = (Boolean)method.invoke(this.repository, fieldValue, idValue) == false;
                log.info("Validated [{}] with field [{}]=[{}] and ID=[{}] and result id [{}]", new Object[]{value.getClass().getName(), this.uniqueField.fieldName(), fieldValue, idValue, result != false ? "valid" : "invalid"});
            }
            return result;
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectiveIncorrectFieldException(e);
        }
    }
}

