/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.service;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.corefinance.common.config.JwtConfiguration;
import tech.corefinance.common.dto.BasicUserDto;
import tech.corefinance.common.dto.JwtTokenDto;

public interface JwtService {
    public String sign(Map<String, Serializable> var1);

    public DecodedJWT verify(String var1, String var2, String var3);

    public String extractIpAddress(HttpServletRequest var1) throws UnknownHostException;

    public Map<String, JwtTokenDto> retrieveTokenFromRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    default public String buildLoginToken(JwtTokenDto jwtTokenDto) throws JsonProcessingException {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        jwtTokenDto.setVerifyKey(this.buildLoginVerifyKey(jwtTokenDto));
        logger.debug("Built verify key [{}]", (Object)jwtTokenDto.getVerifyKey());
        return this.sign(this.buildLoginDataMap(jwtTokenDto));
    }

    public JwtConfiguration getJwtConfiguration();

    default public String buildLoginVerifyKey(JwtTokenDto jwtTokenDto) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        String loginMode = this.getJwtConfiguration().getLoginMode();
        log.debug("Login mode [{}]", (Object)loginMode);
        return switch (loginMode) {
            case "SINGLE_LOGIN" -> jwtTokenDto.getUserId();
            case "SINGLE_LOGIN_PER_APP" -> jwtTokenDto.getUserId() + "||APP||" + jwtTokenDto.getClientAppId();
            case "SINGLE_LOGIN_PER_DEVICE" -> jwtTokenDto.getUserId() + "||DEVICE||" + jwtTokenDto.getDeviceId();
            default -> jwtTokenDto.getLoginId();
        };
    }

    public Map<String, Serializable> buildLoginDataMap(JwtTokenDto var1) throws JsonProcessingException;

    default public String buildRefreshToken(JwtTokenDto jwtTokenDto, String token) throws JsonProcessingException {
        return this.sign(this.buildRefreshTokenDataMap(jwtTokenDto, token));
    }

    public Map<String, Serializable> buildRefreshTokenDataMap(JwtTokenDto var1, String var2) throws JsonProcessingException;

    public BasicUserDto retrieveUserAsAttribute(JwtTokenDto var1);

    public JwtTokenDto decodeToken(String var1, String var2, String var3) throws JsonProcessingException;
}

