/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.service;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import tech.corefinance.common.annotation.InternalApi;
import tech.corefinance.common.context.JwtContext;
import tech.corefinance.common.model.InternalServiceConfig;
import tech.corefinance.common.repository.InternalServiceConfigRepository;
import tech.corefinance.common.service.InternalApiVerify;

@Service
public class InternalApiVerifyImpl
implements InternalApiVerify {
    private static final Logger log = LoggerFactory.getLogger(InternalApiVerifyImpl.class);
    @Autowired
    private InternalServiceConfigRepository internalServiceConfigRepository;

    @Override
    public boolean internalPermissionCheck(Class<?> controllerClass, Method method, HttpServletRequest request) {
        InternalApi internalAnn = method.getAnnotation(InternalApi.class);
        if (internalAnn == null) {
            internalAnn = controllerClass.getAnnotation(InternalApi.class);
        }
        if (internalAnn != null) {
            if (internalAnn.needAuthenToken() && JwtContext.getInstance().getJwt() == null) {
                throw new AccessDeniedException("no_authen_token_found");
            }
            String internalApi = request.getHeader("x-internal-api-key");
            if (!StringUtils.hasText((String)internalApi)) {
                throw new AccessDeniedException("no_internal_key_found");
            }
            Optional<InternalServiceConfig> internalServiceConfigOptional = this.internalServiceConfigRepository.findFirstByApiKeyAndActivatedOrderByLastModifiedDateDesc(internalApi, true);
            InternalServiceConfig config = internalServiceConfigOptional.orElseThrow(() -> new AccessDeniedException("invalid_internal_api_key"));
            log.debug("Received call from service [{}]", (Object)config);
        }
        return true;
    }
}

