/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.service;

import jakarta.annotation.PostConstruct;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.util.Pair;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import tech.corefinance.common.annotation.ControllerManagedResource;
import tech.corefinance.common.annotation.ManualPermissionCheck;
import tech.corefinance.common.annotation.PermissionAction;
import tech.corefinance.common.config.ServiceSecurityConfig;
import tech.corefinance.common.dto.PermissionDto;
import tech.corefinance.common.enums.AccessControl;
import tech.corefinance.common.ex.ReflectiveIncorrectFieldException;
import tech.corefinance.common.model.ResourceAction;
import tech.corefinance.common.repository.ResourceActionRepository;
import tech.corefinance.common.service.PermissionService;
import tech.corefinance.common.util.CoreFinanceUtil;

@Component
@ConditionalOnProperty(prefix="tech.corefinance.security", name={"scan-controllers-actions"}, havingValue="true", matchIfMissing=true)
public class ControllerScanner {
    private static final Logger log = LoggerFactory.getLogger(ControllerScanner.class);
    @Autowired
    private ResourceActionRepository resourceActionRepository;
    @Autowired
    private ServiceSecurityConfig serviceSecurityConfig;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private List<RequestMappingHandlerMapping> handlerMappings;
    @Autowired
    private CoreFinanceUtil coreFinanceUtil;

    @Async
    @PostConstruct
    public void scan() {
        for (RequestMappingHandlerMapping mapping : this.handlerMappings) {
            this.scanHandler(mapping);
        }
    }

    private void scanHandler(RequestMappingHandlerMapping mapping) {
        Map handlerMethods = mapping.getHandlerMethods();
        block0: for (Map.Entry entry : handlerMethods.entrySet()) {
            RequestMappingInfo key = (RequestMappingInfo)entry.getKey();
            HandlerMethod value = (HandlerMethod)entry.getValue();
            Set<Pair<String, String>> urls = this.coreFinanceUtil.buildUrlPair(key.getPatternValues());
            Method method = value.getMethod();
            Class<?> declaringClass = method.getDeclaringClass();
            Class controllerClass = value.getBeanType();
            String controllerClassName = controllerClass.getName();
            log.debug("{}#{} ==> {}", new Object[]{controllerClassName, method.getName(), urls});
            for (String string : this.serviceSecurityConfig.getIgnoreControllerScan()) {
                log.debug("Checking if controller full package contain [{}] or not...", (Object)string);
                if (!controllerClassName.contains(string)) continue;
                log.debug("Skipped permission scan for {}", declaringClass);
                continue block0;
            }
            log.debug("URLs {}", urls);
            for (Pair pair : urls) {
                log.debug("Validating URL [{}]", (Object)pair);
                for (String noAuthenUrl : this.serviceSecurityConfig.getNoAuthenUrls()) {
                    Pattern pattern = Pattern.compile(noAuthenUrl.replace("*", ".*"));
                    boolean matched = pattern.matcher((CharSequence)pair.getSecond()).matches();
                    log.debug("Checking result with pattern [{}] is [{}]", (Object)noAuthenUrl, (Object)matched);
                    if (!matched) continue;
                    continue block0;
                }
            }
            ControllerManagedResource controllerManagedResource = controllerClass.getAnnotation(ControllerManagedResource.class);
            PermissionAction permissionAction = method.getAnnotation(PermissionAction.class);
            ManualPermissionCheck manualPerCheckAnn = method.getAnnotation(ManualPermissionCheck.class);
            if (permissionAction == null && controllerManagedResource == null) {
                log.error("{}={} have no annotation PermissionAction!", (Object)declaringClass.getName(), (Object)method.getName());
                throw new ReflectiveIncorrectFieldException("no_permission_defined");
            }
            String resourceType = this.coreFinanceUtil.resolveResourceType(permissionAction, controllerManagedResource);
            String action = this.coreFinanceUtil.resolveResourceAction(permissionAction, key);
            Set requestMethods = key.getMethodsCondition().getMethods();
            this.buildListActions(resourceType, action, urls, requestMethods);
            if (manualPerCheckAnn == null) continue;
            this.saveManualCheckPermissions(resourceType, action, urls, requestMethods);
        }
    }

    private List<ResourceAction> buildListActions(String resourceType, String action, Iterable<Pair<String, String>> urls, Iterable<RequestMethod> requestMethods) {
        LinkedList<ResourceAction> permissionActions = new LinkedList<ResourceAction>();
        for (Pair<String, String> url : urls) {
            for (RequestMethod requestMethod : requestMethods) {
                log.debug("Checking URL [{}] with method [{}]", url, (Object)requestMethod);
                ResourceAction resourceAction = this.permissionService.newResourceAction(resourceType, action, (String)url.getSecond(), requestMethod);
                if (!this.resourceActionRepository.existsByActionAndRequestMethodAndResourceTypeAndUrl(action, requestMethod, resourceType, (String)url.getSecond())) {
                    log.debug("Saving action [{}]", (Object)resourceAction);
                    permissionActions.add((ResourceAction)this.resourceActionRepository.save(resourceAction));
                    continue;
                }
                log.debug("Skip existed action [{}]", (Object)resourceAction);
            }
        }
        return permissionActions;
    }

    private void saveManualCheckPermissions(String resourceType, String action, Iterable<Pair<String, String>> urls, Iterable<RequestMethod> requestMethods) {
        for (Pair<String, String> url : urls) {
            for (RequestMethod requestMethod : requestMethods) {
                PermissionDto permission = new PermissionDto();
                permission.setControl(AccessControl.MANUAL_CHECK);
                permission.setUrl((String)url.getSecond());
                permission.setRoleId("ANY");
                permission.setResourceType(resourceType);
                permission.setAction(action);
                permission.setRequestMethod(requestMethod);
                this.permissionService.createOrUpdateEntity(permission);
            }
        }
    }
}

