/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.service;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;
import tech.corefinance.common.context.ApplicationContextHolder;
import tech.corefinance.common.ex.ResourceNotFound;
import tech.corefinance.common.ex.ServiceProcessingException;
import tech.corefinance.common.model.CreateUpdateDto;
import tech.corefinance.common.model.GenericModel;
import tech.corefinance.common.repository.CommonResourceRepository;
import tech.corefinance.common.service.SimpleSearchSupport;
import tech.corefinance.common.util.CoreFinanceUtil;

public interface CommonService<I extends Serializable, T extends GenericModel<I>, R extends CommonResourceRepository<T, I>> {
    public R getRepository();

    default public T createEntityObject() {
        try {
            return (T)((GenericModel)this.findEntityClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ServiceProcessingException(e.getMessage(), (Throwable)e);
        }
    }

    default public <D extends CreateUpdateDto<I>> T copyAdditionalPropertiesFromDtoToEntity(D source, T dest) {
        return dest;
    }

    default public <D extends CreateUpdateDto<I>> T customEntityValidation(D source, T dest) {
        return dest;
    }

    default public void afterEntitySaved(T entity) {
    }

    default public boolean deleteEntity(I itemId) {
        R repository = this.getRepository();
        Optional optional = repository.findById(itemId);
        if (optional.isPresent()) {
            GenericModel item = (GenericModel)optional.get();
            this.beforeItemDeleted(item);
            repository.delete((Object)item);
            this.afterItemDeleted(item);
            return true;
        }
        return false;
    }

    default public <D extends CreateUpdateDto<I>> T createOrUpdateEntity(D dto) {
        Object entity;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.info("Entering createOrUpdateEntity...");
        R repository = this.getRepository();
        if (dto.getId() != null) {
            logger.info("Entity ID not empty! Checking if existed in DB or not...");
            Optional optional = repository.findById(dto.getId());
            if (optional.isPresent()) {
                logger.info("Entity found!");
                entity = (GenericModel)optional.get();
            } else {
                logger.info("Entity not found! Creating new entity...");
                entity = this.createEntityObject();
                entity.setId(dto.getId());
            }
        } else {
            logger.info("Entity ID empty! Creating new entity...");
            entity = this.createEntityObject();
        }
        logger.info("Copying matched properties from DTO to entity...");
        BeanUtils.copyProperties(dto, entity);
        logger.info("Calling copyAdditionalPropertiesFromDtoToEntity...");
        entity = this.copyAdditionalPropertiesFromDtoToEntity(dto, entity);
        logger.info("Calling customEntityValidation...");
        entity = this.customEntityValidation(dto, entity);
        logger.info("Save entity to DB...");
        entity = (GenericModel)repository.save(entity);
        logger.info("Call afterEntitySaved and then response");
        this.afterEntitySaved(entity);
        return (T)entity;
    }

    default public Page<T> searchData(String searchText, int pageSize, int pageIndex, List<Sort.Order> orders) {
        List<T> entities;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.info("Search entities");
        R repository = this.getRepository();
        if (pageSize > 0 && pageIndex >= 0) {
            PageRequest pageRequest = PageRequest.of((int)pageIndex, (int)pageSize, (Sort)Sort.by(orders));
            if (StringUtils.hasText((String)searchText)) {
                logger.info("Search by page {} and page index {} and search text [{}]", new Object[]{pageSize, pageIndex, searchText});
                return this.searchByTextAndPage(searchText, (Pageable)pageRequest);
            }
            logger.info("Load by page {} and page index {} without search text.", (Object)pageSize, (Object)pageIndex);
            return repository.findAll((Pageable)pageRequest);
        }
        Sort sort = Sort.by(orders);
        if (StringUtils.hasText((String)searchText)) {
            logger.info("Search by search text [{}] and order {}", (Object)searchText, orders);
            entities = this.searchByTextAndSort(searchText, sort);
        } else {
            logger.info("Load without search text and order {}", orders);
            entities = repository.findAll(sort);
        }
        return new PageImpl(entities);
    }

    default public Page<T> searchByTextAndPage(String searchText, Pageable pageable) {
        ApplicationContext context = ApplicationContextHolder.getInstance().getApplicationContext();
        Map map = context.getBeansOfType(SimpleSearchSupport.class);
        Class<T> entityType = this.findEntityClass();
        for (Map.Entry entry : map.entrySet()) {
            SimpleSearchSupport searchSupport = (SimpleSearchSupport)entry.getValue();
            if (!searchSupport.isSupported(entityType)) continue;
            return searchSupport.searchByTextAndPage(entityType, searchText, pageable);
        }
        throw new UnsupportedOperationException("Not support search by text! Please override searchByTextAndPage and searchByTextAndSort");
    }

    default public List<T> searchByTextAndSort(String searchText, Sort sort) {
        ApplicationContext context = ApplicationContextHolder.getInstance().getApplicationContext();
        Map map = context.getBeansOfType(SimpleSearchSupport.class);
        Class<T> entityType = this.findEntityClass();
        for (Map.Entry entry : map.entrySet()) {
            SimpleSearchSupport searchSupport = (SimpleSearchSupport)entry.getValue();
            if (!searchSupport.isSupported(entityType)) continue;
            return searchSupport.searchByTextAndSort(entityType, searchText, sort);
        }
        throw new UnsupportedOperationException("Not support search by text! Please override searchByTextAndPage and searchByTextAndSort");
    }

    default public T getEntityDetails(I entityId) {
        return (T)((GenericModel)this.getRepository().findById(entityId).orElseThrow(() -> new ResourceNotFound("Cannot find entity for ID " + entityId)));
    }

    default public Class<T> findEntityClass() {
        ApplicationContext context = ApplicationContextHolder.getInstance().getApplicationContext();
        return ((CoreFinanceUtil)context.getBean(CoreFinanceUtil.class)).findEntityTypeFromCommonService(this.getClass());
    }

    default public void beforeItemDeleted(T item) {
    }

    default public void afterItemDeleted(T item) {
    }
}

