/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.repository;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.FluentQuery;
import tech.corefinance.common.ex.ServiceProcessingException;
import tech.corefinance.common.model.GenericModel;
import tech.corefinance.common.repository.CommonResourceRepository;
import tech.corefinance.common.repository.InMemoryIdGenerator;
import tech.corefinance.common.repository.InMemoryStringIdGenerator;
import tech.corefinance.common.repository.InMemoryUuidGenerator;
import tech.corefinance.common.util.CoreFinanceUtil;

public class InMemoryRepository<T extends GenericModel<ID>, ID extends Serializable>
implements CommonResourceRepository<T, ID> {
    private static final String VALIDATION_FAIL_MESSAGE = "entity_validation_fail";
    protected Map<ID, T> data = new HashMap<ID, T>();
    protected Long maxGeneratedId = 0L;
    protected Class<T> entityClass;
    protected Class<ID> idClass;
    protected final Object lock = new Object();
    protected final CoreFinanceUtil coreFinanceUtil;

    public InMemoryRepository(Class<T> entityClass, Class<ID> idClass, CoreFinanceUtil coreFinanceUtil) {
        this.entityClass = entityClass;
        this.idClass = idClass;
        this.coreFinanceUtil = coreFinanceUtil;
    }

    public boolean validateEntity(T entity) {
        return true;
    }

    public <S extends T> S save(S entity) {
        if (!this.validateEntity(entity)) {
            throw new ServiceProcessingException(VALIDATION_FAIL_MESSAGE);
        }
        Object id = entity.getId();
        if (id == null) {
            id = this.generateId();
            entity.setId(id);
        } else {
            GenericModel oldData = (GenericModel)this.data.get(id);
            if (oldData != null) {
                this.data.remove(id);
            }
            this.data.put(id, entity);
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ID generateId() {
        InMemoryIdGenerator<UUID> generator = null;
        if (this.idClass.equals(UUID.class)) {
            generator = new InMemoryUuidGenerator();
        } else if (this.idClass.equals(String.class)) {
            generator = new InMemoryStringIdGenerator();
        }
        if (generator != null) {
            return (ID)((Serializable)generator.generateId());
        }
        if (this.idClass.equals(Long.class) || this.idClass.equals(Long.TYPE) || this.idClass.equals(Integer.TYPE) || this.idClass.equals(Integer.class)) {
            Object object = this.lock;
            synchronized (object) {
                Long l = this.maxGeneratedId;
                this.maxGeneratedId = this.maxGeneratedId + 1L;
            }
            return (ID)this.maxGeneratedId;
        }
        throw new ServiceProcessingException("unsupported_id_type");
    }

    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        LinkedList result = new LinkedList();
        entities.forEach(e -> result.add(this.save((S)e)));
        return result;
    }

    public Optional<T> findById(ID id) {
        GenericModel value = (GenericModel)this.data.get(id);
        if (value != null) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public boolean existsById(ID id) {
        return this.data.containsKey(id);
    }

    public List<T> findAll() {
        return this.data.values().stream().toList();
    }

    public List<T> findAllById(Iterable<ID> ids) {
        LinkedList result = new LinkedList();
        ids.forEach(id -> result.add((GenericModel)this.data.get(id)));
        return result;
    }

    public long count() {
        return this.data.size();
    }

    public void deleteById(ID id) {
        this.data.remove(id);
    }

    public void delete(T entity) {
        this.data.remove(entity.getId());
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
        ids.forEach(this.data::remove);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        entities.forEach(e -> this.data.remove(e.getId()));
    }

    public void deleteAll() {
        this.data.clear();
    }

    protected List<T> sort(List<T> entities, Sort sort) {
        if (sort != null && sort.isSorted()) {
            entities.sort((o1, o2) -> {
                for (Sort.Order o : sort) {
                    try {
                        AccessibleObject field1Access = this.coreFinanceUtil.accessField(o1, o1.getClass(), o.getProperty());
                        field1Access.setAccessible(true);
                        AccessibleObject field2Access = this.coreFinanceUtil.accessField(o2, o2.getClass(), o.getProperty());
                        field2Access.setAccessible(true);
                        Object field1Val = this.coreFinanceUtil.triggerGetFieldValue(field1Access, o1, o1.getClass());
                        Object field2Val = this.coreFinanceUtil.triggerGetFieldValue(field1Access, o2, o2.getClass());
                        int result = this.compare(field1Val, field2Val, o.isAscending());
                        if (result == 0) continue;
                        return result;
                    }
                    catch (Exception ex) {
                        throw new ServiceProcessingException(ex.getMessage(), (Throwable)ex);
                    }
                }
                return 0;
            });
        }
        return entities;
    }

    protected int compare(Object val1, Object val2, boolean isAscending) {
        int comparedVal;
        if (val1 == null || val2 == null) {
            if (val1 == val2) {
                return 0;
            }
            if (val1 == null) {
                return isAscending ? -1 : 1;
            }
            return isAscending ? 1 : -1;
        }
        if (val1 instanceof Comparable) {
            Comparable v1 = (Comparable)val1;
            comparedVal = v1.compareTo(val2);
        } else {
            comparedVal = val1.toString().compareTo(val2.toString());
        }
        if (comparedVal == 0) {
            return 0;
        }
        return isAscending ? comparedVal : -1 * comparedVal;
    }

    public List<T> findAll(Sort sort) {
        return this.sort((List<T>)this.findAll(), sort);
    }

    public Page<T> findAll(Pageable pageable) {
        Iterable result = this.findAll();
        int pageSize = pageable.getPageSize();
        int pageNumber = pageable.getPageNumber();
        int count = result.size();
        if (pageable.isPaged() && pageSize > 0 && pageNumber >= 0 && count > 0) {
            int numberOfPage = count / pageSize + (count % pageSize > 0 ? 1 : 0);
            if (numberOfPage <= 0) {
                return new PageImpl(this.sort((List<T>)result, pageable.getSort()));
            }
            if (pageNumber >= numberOfPage) {
                pageNumber = numberOfPage - 1;
            }
            int offset = pageNumber * pageSize;
            PageRequest newPageable = PageRequest.of((int)pageNumber, (int)pageSize);
            int toIndex = offset + pageSize;
            if (toIndex >= count) {
                toIndex = count - 1;
            }
            return new PageImpl(this.sort(result.subList(offset, toIndex), pageable.getSort()), (Pageable)newPageable, (long)count);
        }
        return new PageImpl(this.sort((List<T>)result, pageable.getSort()));
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        throw new UnsupportedOperationException();
    }

    public <S extends T> Iterable<S> findAll(Example<S> example) {
        throw new UnsupportedOperationException();
    }

    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        throw new UnsupportedOperationException();
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        throw new UnsupportedOperationException();
    }

    public <S extends T> long count(Example<S> example) {
        throw new UnsupportedOperationException();
    }

    public <S extends T> boolean exists(Example<S> example) {
        throw new UnsupportedOperationException();
    }

    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        throw new UnsupportedOperationException();
    }
}

