/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.web.bind.annotation.RequestMethod;
import tech.corefinance.common.enums.AccessControl;
import tech.corefinance.common.model.GenericModel;

@Document(value="permission")
@Table(name="permission")
@Entity
public class Permission
implements GenericModel<String> {
    public static final String ANY_ROLE_APPLIED_VALUE = "ANY";
    @org.springframework.data.annotation.Id
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private String id;
    @NotNull
    @Column(name="role_id")
    private String roleId;
    @NotNull
    @Column(name="resource_type")
    private String resourceType;
    @NotNull
    private String action;
    private String url;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private AccessControl control;
    @Column(name="request_method")
    @Enumerated(value=EnumType.STRING)
    private RequestMethod requestMethod;

    @Override
    public String getId() {
        return this.id;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getAction() {
        return this.action;
    }

    public String getUrl() {
        return this.url;
    }

    public AccessControl getControl() {
        return this.control;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setControl(AccessControl control) {
        this.control = control;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$roleId = this.getRoleId();
        String other$roleId = other.getRoleId();
        if (this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        AccessControl this$control = this.getControl();
        AccessControl other$control = other.getControl();
        if (this$control == null ? other$control != null : !((Object)((Object)this$control)).equals((Object)other$control)) {
            return false;
        }
        RequestMethod this$requestMethod = this.getRequestMethod();
        RequestMethod other$requestMethod = other.getRequestMethod();
        return !(this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Permission;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $roleId = this.getRoleId();
        result = result * 59 + ($roleId == null ? 43 : $roleId.hashCode());
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        AccessControl $control = this.getControl();
        result = result * 59 + ($control == null ? 43 : ((Object)((Object)$control)).hashCode());
        RequestMethod $requestMethod = this.getRequestMethod();
        result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
        return result;
    }

    public String toString() {
        return "Permission(id=" + this.getId() + ", roleId=" + this.getRoleId() + ", resourceType=" + this.getResourceType() + ", action=" + this.getAction() + ", url=" + this.getUrl() + ", control=" + this.getControl() + ", requestMethod=" + this.getRequestMethod() + ")";
    }
}

