/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import tech.corefinance.common.context.TraceIdContext;

@Component
@ConditionalOnProperty(prefix="tech.corefinance.common.enabled", name={"trace-id-filter"}, havingValue="true", matchIfMissing=true)
public class TraceInfoFilter
implements Filter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(TraceInfoFilter.class);
    @Value(value="${tech.corefinance.common.filter-ordered.trace-info-id-order:1}")
    private int order;

    public int getOrder() {
        return this.order;
    }

    public void init(FilterConfig filterConfig) {
        log.debug("Initializing trace info filter...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        TraceIdContext traceIdContext = TraceIdContext.getInstance();
        log.debug("Checking trace id header [{}] in the request...", (Object)"x-trace-id");
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            String traceId = httpServletRequest.getHeader("x-trace-id");
            log.debug("Trace id value [{}]", (Object)traceId);
            if (StringUtils.isBlank((CharSequence)traceId)) {
                traceId = UUID.randomUUID().toString();
            }
            traceIdContext.setTraceId(traceId);
            httpServletResponse.setHeader("x-trace-id", URLEncoder.encode(traceId, StandardCharsets.US_ASCII));
            log.debug("Set trace id [{}] to context and response.", (Object)traceId);
            log.debug("Continue filter chain");
            chain.doFilter(request, response);
        }
        finally {
            log.debug("Clear trace id in the context!");
            traceIdContext.clearTraceId();
        }
    }

    public void destroy() {
        log.debug("Destroy trace info filter!");
    }
}

