/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.filter;

import com.auth0.jwt.exceptions.JWTVerificationException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import tech.corefinance.common.context.JwtContext;
import tech.corefinance.common.dto.JwtTokenDto;
import tech.corefinance.common.service.JwtService;

@ConditionalOnProperty(prefix="tech.corefinance.security", name={"public-key"})
@Component
public class SessionAuthenticationFilter
extends OncePerRequestFilter
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(SessionAuthenticationFilter.class);
    @Autowired
    private JwtService jwtService;
    @Value(value="${tech.corefinance.common.filter-ordered.authen-filter:2}")
    private int ordered;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            Map<String, JwtTokenDto> map = this.jwtService.retrieveTokenFromRequest(request, response);
            String tokenString = "";
            JwtTokenDto jwtTokenDto = null;
            Set<String> set = map.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String key;
                tokenString = key = iterator.next();
                jwtTokenDto = map.get(key);
            }
            if (jwtTokenDto != null) {
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)jwtTokenDto.getUsername(), null, this.getAuthorities(jwtTokenDto));
                authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                JwtContext.getInstance().setJwt(jwtTokenDto);
                JwtContext.getInstance().setTokenString(tokenString);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (JWTVerificationException | BadCredentialsException e) {
            log.debug("Error", e);
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            response.setContentType("text/plain");
            String message = e.getMessage();
            response.setContentLength(message.length());
            try (ServletOutputStream ops = response.getOutputStream();
                 PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)ops, StandardCharsets.UTF_8));){
                pw.print(message);
            }
        }
        finally {
            JwtContext.getInstance().removeJwt();
            JwtContext.getInstance().removeTokenString();
        }
    }

    private Set<GrantedAuthority> getAuthorities(JwtTokenDto jwtTokenDto) {
        HashSet<GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
        authorities.addAll(jwtTokenDto.getUserRoles());
        return authorities;
    }

    public int getOrder() {
        return this.ordered;
    }
}

