/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.validation.constraints.NotEmpty;
import org.springframework.security.core.GrantedAuthority;

public class UserRoleDto
implements GrantedAuthority {
    private String resourceType;
    private String resourceId;
    @NotEmpty(message="roleId_must_not_null")
    private @NotEmpty(message="roleId_must_not_null") String roleId;
    private String roleName;

    public UserRoleDto(String resourceType, String resourceId, String roleId) {
        this(resourceType, resourceId, roleId, "NA");
    }

    public UserRoleDto(String jsonString) {
        UserRoleDto that = (UserRoleDto)new ObjectMapper().readValue(jsonString, this.getClass());
        this.resourceId = that.resourceId;
        this.resourceType = that.resourceType;
        this.roleId = that.roleId;
        this.roleName = that.roleName;
    }

    @JsonIgnore
    public String getAuthority() {
        return this.resourceType + "_" + this.resourceId + "_" + this.roleId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserRoleDto)) {
            return false;
        }
        UserRoleDto other = (UserRoleDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$resourceType = this.getResourceType();
        String other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$roleId = this.getRoleId();
        String other$roleId = other.getRoleId();
        if (this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId)) {
            return false;
        }
        String this$roleName = this.getRoleName();
        String other$roleName = other.getRoleName();
        return !(this$roleName == null ? other$roleName != null : !this$roleName.equals(other$roleName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserRoleDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $roleId = this.getRoleId();
        result = result * 59 + ($roleId == null ? 43 : $roleId.hashCode());
        String $roleName = this.getRoleName();
        result = result * 59 + ($roleName == null ? 43 : $roleName.hashCode());
        return result;
    }

    public String toString() {
        return "UserRoleDto(resourceType=" + this.getResourceType() + ", resourceId=" + this.getResourceId() + ", roleId=" + this.getRoleId() + ", roleName=" + this.getRoleName() + ")";
    }

    public UserRoleDto() {
    }

    public UserRoleDto(String resourceType, String resourceId, String roleId, String roleName) {
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.roleId = roleId;
        this.roleName = roleName;
    }
}

