/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.springframework.data.domain.Page;
import tech.corefinance.common.dto.GeneralApiResponse;
import tech.corefinance.common.dto.OrderDto;

public class PageDto<T>
extends GeneralApiResponse<List<T>> {
    private static final long serialVersionUID = -9141677225193449525L;
    private List<OrderDto> orders;
    private int pageNumber;
    private int pageSize;
    private long totalElements;
    private int totalPages;

    public PageDto() {
    }

    public PageDto(String statusCode, int status, Page<T> page) {
        super(statusCode, status, page.getContent());
        this.setPageData(page);
    }

    public PageDto(Page<T> page) {
        super(page.getContent());
        this.setPageData(page);
    }

    @Schema(hidden=true)
    public void setPageData(Page<T> page) {
        this.setResult(page.getContent());
        this.orders = page.getSort().stream().map(OrderDto::fromOrder).toList();
        this.pageNumber = page.getNumber();
        this.pageSize = page.getSize();
        this.totalElements = page.getTotalElements();
        this.totalPages = page.getTotalPages();
    }

    public boolean isEmpty() {
        return ((List)this.getResult()).isEmpty();
    }

    public int getNumberOfElements() {
        return ((List)this.getResult()).size();
    }

    public static <T> PageDto<T> createSuccessResponse(Page<T> page) {
        return new PageDto<T>("OK", STATUS_SUCCESS, page);
    }

    public boolean isHasNext() {
        return this.pageNumber < this.totalPages - 1;
    }

    public boolean isHasPrevious() {
        return this.pageNumber > 0;
    }

    public boolean isFirst() {
        return this.pageNumber <= 0;
    }

    public boolean isLast() {
        return this.pageNumber >= this.totalPages - 1;
    }

    public List<OrderDto> getOrders() {
        return this.orders;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getTotalElements() {
        return this.totalElements;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setOrders(List<OrderDto> orders) {
        this.orders = orders;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalElements(long totalElements) {
        this.totalElements = totalElements;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    @Override
    public String toString() {
        return "PageDto(orders=" + this.getOrders() + ", pageNumber=" + this.getPageNumber() + ", pageSize=" + this.getPageSize() + ", totalElements=" + this.getTotalElements() + ", totalPages=" + this.getTotalPages() + ")";
    }

    public PageDto(List<OrderDto> orders, int pageNumber, int pageSize, long totalElements, int totalPages) {
        this.orders = orders;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.totalElements = totalElements;
        this.totalPages = totalPages;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageDto)) {
            return false;
        }
        PageDto other = (PageDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPageNumber() != other.getPageNumber()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotalElements() != other.getTotalElements()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        List<OrderDto> this$orders = this.getOrders();
        List<OrderDto> other$orders = other.getOrders();
        return !(this$orders == null ? other$orders != null : !((Object)this$orders).equals(other$orders));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PageDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPageNumber();
        result = result * 59 + this.getPageSize();
        long $totalElements = this.getTotalElements();
        result = result * 59 + (int)($totalElements >>> 32 ^ $totalElements);
        result = result * 59 + this.getTotalPages();
        List<OrderDto> $orders = this.getOrders();
        result = result * 59 + ($orders == null ? 43 : ((Object)$orders).hashCode());
        return result;
    }
}

