/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.dto;

import java.io.Serializable;
import java.util.Map;

public class GeneralApiResponse<T>
implements Serializable {
    private static final long serialVersionUID = -6412669348869863966L;
    public static int STATUS_SUCCESS = 0;
    public static int STATUS_UNKNOWN_ERROR = 1;
    private String statusCode;
    private int status;
    private T result;
    private Long processingMilliseconds;
    private Map<String, String[]> errorKeysWithData = null;

    public GeneralApiResponse(String statusCode, int status, T result) {
        this.statusCode = statusCode;
        this.status = status;
        this.result = result;
    }

    public GeneralApiResponse(T result) {
        this("", STATUS_SUCCESS, result);
    }

    public static GeneralApiResponse<String> createErrorResponseWithCode(String errorCode) {
        return new GeneralApiResponse<Object>(errorCode, STATUS_UNKNOWN_ERROR, null);
    }

    public static GeneralApiResponse<String> createErrorResponseWithCode(Enum<?> errorCode) {
        return GeneralApiResponse.createErrorResponseWithCode(errorCode.name());
    }

    public static <T> GeneralApiResponse<T> createSuccessResponse(T result) {
        return new GeneralApiResponse<T>("OK", STATUS_SUCCESS, result);
    }

    public static <T> GeneralApiResponse<T> createErrorResponseWithCode(String errorCode, T result) {
        return new GeneralApiResponse<Object>(errorCode, STATUS_UNKNOWN_ERROR, null);
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public int getStatus() {
        return this.status;
    }

    public T getResult() {
        return this.result;
    }

    public Long getProcessingMilliseconds() {
        return this.processingMilliseconds;
    }

    public Map<String, String[]> getErrorKeysWithData() {
        return this.errorKeysWithData;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setResult(T result) {
        this.result = result;
    }

    public void setProcessingMilliseconds(Long processingMilliseconds) {
        this.processingMilliseconds = processingMilliseconds;
    }

    public void setErrorKeysWithData(Map<String, String[]> errorKeysWithData) {
        this.errorKeysWithData = errorKeysWithData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeneralApiResponse)) {
            return false;
        }
        GeneralApiResponse other = (GeneralApiResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        Long this$processingMilliseconds = this.getProcessingMilliseconds();
        Long other$processingMilliseconds = other.getProcessingMilliseconds();
        if (this$processingMilliseconds == null ? other$processingMilliseconds != null : !((Object)this$processingMilliseconds).equals(other$processingMilliseconds)) {
            return false;
        }
        String this$statusCode = this.getStatusCode();
        String other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
            return false;
        }
        T this$result = this.getResult();
        T other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        Map<String, String[]> this$errorKeysWithData = this.getErrorKeysWithData();
        Map<String, String[]> other$errorKeysWithData = other.getErrorKeysWithData();
        return !(this$errorKeysWithData == null ? other$errorKeysWithData != null : !((Object)this$errorKeysWithData).equals(other$errorKeysWithData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeneralApiResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        Long $processingMilliseconds = this.getProcessingMilliseconds();
        result = result * 59 + ($processingMilliseconds == null ? 43 : ((Object)$processingMilliseconds).hashCode());
        String $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
        T $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        Map<String, String[]> $errorKeysWithData = this.getErrorKeysWithData();
        result = result * 59 + ($errorKeysWithData == null ? 43 : ((Object)$errorKeysWithData).hashCode());
        return result;
    }

    public String toString() {
        return "GeneralApiResponse(statusCode=" + this.getStatusCode() + ", status=" + this.getStatus() + ", result=" + this.getResult() + ", processingMilliseconds=" + this.getProcessingMilliseconds() + ", errorKeysWithData=" + this.getErrorKeysWithData() + ")";
    }

    public GeneralApiResponse() {
    }

    public GeneralApiResponse(String statusCode, int status, T result, Long processingMilliseconds, Map<String, String[]> errorKeysWithData) {
        this.statusCode = statusCode;
        this.status = status;
        this.result = result;
        this.processingMilliseconds = processingMilliseconds;
        this.errorKeysWithData = errorKeysWithData;
    }
}

