/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.converter.log;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.commons.lang3.StringUtils;

public abstract class LogDataConverter
extends ClassicConverter {
    private String outputFormat;
    private boolean returnEmptyIfDataBlank;
    private String label;

    protected LogDataConverter(String outputFormat, boolean returnEmptyIfDataBlank, String label) {
        this.outputFormat = outputFormat;
        this.returnEmptyIfDataBlank = returnEmptyIfDataBlank;
        this.label = label;
    }

    protected LogDataConverter(String label) {
        this("[%label%: %data%]", true, label);
    }

    public String convert(ILoggingEvent event) {
        String data = this.retrieveData();
        if (this.returnEmptyIfDataBlank && StringUtils.isBlank((CharSequence)data)) {
            return "";
        }
        return this.outputFormat.replace("%label%", this.label).replace("%data%", StringUtils.trimToEmpty((String)data));
    }

    protected abstract String retrieveData();
}

