/*
 * Decompiled with CFR 0.152.
 */
package tech.corefinance.common.converter;

import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import tech.corefinance.common.converter.CommonCustomConverter;

@Component
@ConditionalOnProperty(name={"tech.corefinance.app.converter.local-date-to-string"}, havingValue="true", matchIfMissing=true)
@WritingConverter
public class ChronoLocalDateToStringConverter
implements GenericConverter,
CommonCustomConverter<ChronoLocalDate, String> {
    public String convert(@Nullable ChronoLocalDate date) {
        if (date == null) {
            return null;
        }
        return date.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> result = new HashSet<GenericConverter.ConvertiblePair>();
        result.add(new GenericConverter.ConvertiblePair(ChronoLocalDate.class, String.class));
        return result;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.convert((ChronoLocalDate)source);
    }
}

